/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import org.openide.explorer.view.ViewUtil;
import org.openide.explorer.view.Visualizer;
import org.openide.explorer.view.VisualizerNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

class TreeViewCellEditor
extends DefaultTreeCellEditor
implements CellEditorListener,
FocusListener,
MouseMotionListener,
MouseListener {
    static final long serialVersionUID = -2171725285964032312L;
    boolean dndActive = false;
    private boolean cancelled = false;
    private boolean stopped = false;
    private boolean wasFocusOwner = true;

    public TreeViewCellEditor(JTree jTree) {
        super(jTree, new DefaultTreeCellRenderer());
        if (jTree.getSelectionCount() == 1) {
            this.lastPath = jTree.getSelectionPath();
        }
        this.addCellEditorListener(this);
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        Node node;
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        TreePath treePath = this.lastPath;
        if (treePath != null && (node = Visualizer.findNode(treePath.getLastPathComponent())) != null && node.canRename()) {
            String string = (String)this.getCellEditorValue();
            ViewUtil.nodeRename(node, string);
        }
    }

    @Override
    public void editingCanceled(ChangeEvent changeEvent) {
        this.cancelled = true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JTextField) {
            this.cancelled = true;
            this.cancelCellEditing();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.tree) {
            this.abortTimer();
            return;
        }
        if (this.stopped || this.cancelled) {
            return;
        }
        if (!this.stopCellEditing()) {
            this.cancelCellEditing();
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    protected TreeCellEditor createTreeCellEditor() {
        JTextField jTextField = new JTextField(){

            @Override
            public void addNotify() {
                TreeViewCellEditor.this.stopped = (TreeViewCellEditor.this.cancelled = false);
                super.addNotify();
                this.requestFocus();
            }
        };
        jTextField.registerKeyboardAction(this, KeyStroke.getKeyStroke(27, 0, true), 0);
        jTextField.addFocusListener(this);
        Ed ed = new Ed(jTextField);
        ed.setClickCountToStart(1);
        ed.getComponent().getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TreeViewCellEditor.class, (String)"ACSD_TreeViewCellEditor"));
        ed.getComponent().getAccessibleContext().setAccessibleName(NbBundle.getMessage(TreeViewCellEditor.class, (String)"ACSN_TreeViewCellEditor"));
        return ed;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject != null && eventObject instanceof MouseEvent) {
            if (!SwingUtilities.isLeftMouseButton((MouseEvent)eventObject) || ((MouseEvent)eventObject).isPopupTrigger()) {
                this.abortTimer();
                return false;
            }
            if (!this.wasFocusOwner) {
                this.wasFocusOwner = true;
                return false;
            }
        }
        if (this.lastPath != null) {
            Node node = Visualizer.findNode(this.lastPath.getLastPathComponent());
            if (node == null || !node.canRename()) {
                return false;
            }
        } else {
            return false;
        }
        if (this.dndActive) {
            return false;
        }
        return super.isCellEditable(eventObject);
    }

    @Override
    protected void determineOffset(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        if (this.renderer != null) {
            this.renderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, true);
            this.editingIcon = this.renderer.getIcon();
            this.offset = this.editingIcon != null ? this.renderer.getIconTextGap() + this.editingIcon.getIconWidth() : 0;
        } else {
            this.editingIcon = null;
            this.offset = 0;
        }
    }

    void setDnDActive(boolean bl) {
        if (!bl) {
            this.tree.removeMouseMotionListener(this);
        }
        this.dndActive = bl;
    }

    @Override
    protected void setTree(JTree jTree) {
        if (jTree != this.tree && this.timer != null && this.timer.isRunning()) {
            this.tree.removeMouseMotionListener(this);
        }
        if (jTree != this.tree) {
            if (this.tree != null) {
                this.tree.removeMouseListener(this);
                this.tree.removeFocusListener(this);
            }
            if (jTree != null) {
                jTree.addMouseListener(this);
                jTree.addFocusListener(this);
            }
        }
        super.setTree(jTree);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        boolean bl = this.checkContinueTimer(point);
        if (!bl) {
            this.abortTimer();
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        boolean bl = this.checkContinueTimer(point);
        if (!bl) {
            this.abortTimer();
        }
    }

    void abortTimer() {
        if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
            this.tree.removeMouseMotionListener(this);
        }
    }

    @Override
    protected void startEditingTimer() {
        this.tree.addMouseMotionListener(this);
        super.startEditingTimer();
    }

    @Override
    protected void prepareForEditing() {
        this.abortTimer();
        this.tree.removeMouseMotionListener(this);
        super.prepareForEditing();
    }

    private boolean checkContinueTimer(Point point) {
        Rectangle rectangle = this.tree.getPathBounds(this.tree.getSelectionPath());
        if (rectangle == null) {
            return false;
        }
        return rectangle.contains(point);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.wasFocusOwner = this.tree.isFocusOwner();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    class Ed
    extends DefaultCellEditor {
        static final long serialVersionUID = -6373058702842751408L;

        public Ed(JTextField jTextField) {
            super(jTextField);
        }

        @Override
        public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            Node node = Visualizer.findNode(object);
            if (node != null && node.canRename()) {
                this.delegate.setValue(node.getName());
            } else {
                this.delegate.setValue("");
            }
            TreeViewCellEditor.this.editingIcon = ((VisualizerNode)object).getIcon(bl2, false);
            ((JTextField)this.editorComponent).selectAll();
            return this.editorComponent;
        }
    }
}

