/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.swing.JTree;
import javax.swing.SwingWorker;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import sun.tools.jconsole.JConsole;
import sun.tools.jconsole.MBeansTab;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.inspector.Utils;
import sun.tools.jconsole.inspector.XMBean;
import sun.tools.jconsole.inspector.XNodeInfo;

public class XTree
extends JTree {
    private static final List<String> orderedKeyPropertyList = new ArrayList<String>();
    private MBeansTab mbeansTab;
    private Map<String, DefaultMutableTreeNode> nodes = new HashMap<String, DefaultMutableTreeNode>();
    private static boolean treeView;
    private static boolean treeViewInit;
    private boolean keyValueView = Boolean.getBoolean("keyValueView");

    public XTree(MBeansTab mBeansTab) {
        this((TreeNode)new DefaultMutableTreeNode("MBeanTreeRootNode"), mBeansTab);
    }

    public XTree(TreeNode treeNode, MBeansTab mBeansTab) {
        super(treeNode, true);
        this.mbeansTab = mBeansTab;
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    private synchronized void removeChildNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        defaultTreeModel.removeNodeFromParent(defaultMutableTreeNode);
    }

    private synchronized void addChildNode(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2, int n) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        defaultTreeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, n);
    }

    private synchronized void addChildNode(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
        int n = defaultMutableTreeNode.getChildCount();
        if (n == 0) {
            this.addChildNode(defaultMutableTreeNode, defaultMutableTreeNode2, 0);
            return;
        }
        if (defaultMutableTreeNode2 instanceof ComparableDefaultMutableTreeNode) {
            ComparableDefaultMutableTreeNode comparableDefaultMutableTreeNode = (ComparableDefaultMutableTreeNode)defaultMutableTreeNode2;
            for (int i = n - 1; i >= 0; --i) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                if ((i > 2 || !this.isMetadataNode(defaultMutableTreeNode3)) && comparableDefaultMutableTreeNode.compareTo(defaultMutableTreeNode3) < 0) continue;
                this.addChildNode(defaultMutableTreeNode, defaultMutableTreeNode2, i + 1);
                return;
            }
            this.addChildNode(defaultMutableTreeNode, defaultMutableTreeNode2, 0);
            return;
        }
        this.addChildNode(defaultMutableTreeNode, defaultMutableTreeNode2, n);
    }

    @Override
    public synchronized void removeAll() {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
        defaultMutableTreeNode.removeAllChildren();
        defaultTreeModel.nodeStructureChanged(defaultMutableTreeNode);
        this.nodes.clear();
    }

    public synchronized void removeMBeanFromView(ObjectName objectName) {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        Dn dn = new Dn(objectName);
        if (dn.getTokenCount() > 0) {
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
            Token token = dn.getToken(0);
            String string = dn.getHashKey(token);
            defaultMutableTreeNode = this.nodes.get(string);
            if (defaultMutableTreeNode != null && !defaultMutableTreeNode.isRoot()) {
                if (this.hasNonMetadataNodes(defaultMutableTreeNode)) {
                    this.removeMetadataNodes(defaultMutableTreeNode);
                    String string2 = token.getValue();
                    XNodeInfo xNodeInfo = new XNodeInfo(XNodeInfo.Type.NONMBEAN, string2, string2, token.getTokenValue());
                    this.changeNodeValue(defaultMutableTreeNode, xNodeInfo);
                } else {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                    defaultTreeModel.removeNodeFromParent(defaultMutableTreeNode);
                    this.nodes.remove(string);
                    this.removeParentFromView(dn, 1, defaultMutableTreeNode2);
                }
            }
        }
    }

    private boolean hasNonMetadataNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        block3: while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            Object object = defaultMutableTreeNode2.getUserObject();
            if (object instanceof XNodeInfo) {
                switch (((XNodeInfo)object).getType()) {
                    case ATTRIBUTES: 
                    case NOTIFICATIONS: 
                    case OPERATIONS: {
                        continue block3;
                    }
                }
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean hasMetadataNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            Object object = defaultMutableTreeNode2.getUserObject();
            if (object instanceof XNodeInfo) {
                switch (((XNodeInfo)object).getType()) {
                    case ATTRIBUTES: 
                    case NOTIFICATIONS: 
                    case OPERATIONS: {
                        return true;
                    }
                }
                continue;
            }
            return false;
        }
        return false;
    }

    public boolean isMetadataNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof XNodeInfo) {
            switch (((XNodeInfo)object).getType()) {
                case ATTRIBUTES: 
                case NOTIFICATIONS: 
                case OPERATIONS: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private void removeMetadataNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
        HashSet<DefaultMutableTreeNode> hashSet = new HashSet<DefaultMutableTreeNode>();
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            Object object = defaultMutableTreeNode2.getUserObject();
            if (!(object instanceof XNodeInfo)) continue;
            switch (((XNodeInfo)object).getType()) {
                case ATTRIBUTES: 
                case NOTIFICATIONS: 
                case OPERATIONS: {
                    hashSet.add(defaultMutableTreeNode2);
                    break;
                }
            }
        }
        for (DefaultMutableTreeNode defaultMutableTreeNode2 : hashSet) {
            defaultTreeModel.removeNodeFromParent(defaultMutableTreeNode2);
        }
    }

    private DefaultMutableTreeNode removeParentFromView(Dn dn, int n, DefaultMutableTreeNode defaultMutableTreeNode) {
        if (!defaultMutableTreeNode.isRoot() && defaultMutableTreeNode.isLeaf() && !((XNodeInfo)defaultMutableTreeNode.getUserObject()).getType().equals((Object)XNodeInfo.Type.MBEAN)) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            this.removeChildNode(defaultMutableTreeNode);
            String string = dn.getHashKey(dn.getToken(n));
            this.nodes.remove(string);
            this.removeParentFromView(dn, n + 1, defaultMutableTreeNode2);
        }
        return defaultMutableTreeNode;
    }

    public synchronized void addMBeansToView(Set<ObjectName> set) {
        Comparable<Dn> comparable;
        TreeSet<Dn> treeSet = new TreeSet<Dn>();
        for (ObjectName comparable2 : set) {
            comparable = new Dn(comparable2);
            treeSet.add((Dn)comparable);
        }
        for (Dn dn : treeSet) {
            comparable = dn.getObjectName();
            XMBean xMBean = new XMBean((ObjectName)comparable, this.mbeansTab);
            this.addMBeanToView((ObjectName)comparable, xMBean, dn);
        }
    }

    public synchronized void addMBeanToView(ObjectName objectName) {
        XMBean xMBean = new XMBean(objectName, this.mbeansTab);
        Dn dn = new Dn(objectName);
        this.addMBeanToView(objectName, xMBean, dn);
    }

    private synchronized void addMBeanToView(ObjectName objectName, XMBean xMBean, Dn dn) {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        Token token = dn.getToken(0);
        String string = dn.getHashKey(token);
        if (this.nodes.containsKey(string)) {
            defaultMutableTreeNode = this.nodes.get(string);
            Object object = this.createNodeValue(xMBean, token);
            String string2 = object.toString();
            XNodeInfo xNodeInfo = new XNodeInfo(XNodeInfo.Type.MBEAN, object, string2, objectName.toString());
            this.changeNodeValue(defaultMutableTreeNode, xNodeInfo);
            return;
        }
        defaultMutableTreeNode = this.createDnNode(dn, token, xMBean);
        this.nodes.put(string, defaultMutableTreeNode);
        for (int i = 1; i < dn.getTokenCount(); ++i) {
            token = dn.getToken(i);
            string = dn.getHashKey(token);
            if (this.nodes.containsKey(string)) {
                defaultMutableTreeNode2 = this.nodes.get(string);
                this.addChildNode(defaultMutableTreeNode2, defaultMutableTreeNode);
                return;
            }
            if ("domain".equals(token.getTokenType())) {
                defaultMutableTreeNode2 = this.createDomainNode(dn, token);
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)this.getModel().getRoot();
                this.addChildNode(defaultMutableTreeNode3, defaultMutableTreeNode2);
            } else {
                defaultMutableTreeNode2 = this.createSubDnNode(dn, token);
            }
            this.nodes.put(string, defaultMutableTreeNode2);
            this.addChildNode(defaultMutableTreeNode2, defaultMutableTreeNode);
            defaultMutableTreeNode = defaultMutableTreeNode2;
        }
    }

    private synchronized void changeNodeValue(DefaultMutableTreeNode defaultMutableTreeNode, XNodeInfo xNodeInfo) {
        Serializable serializable;
        Serializable serializable2;
        if (defaultMutableTreeNode instanceof ComparableDefaultMutableTreeNode) {
            serializable2 = (DefaultMutableTreeNode)defaultMutableTreeNode.clone();
            ((DefaultMutableTreeNode)serializable2).setUserObject(xNodeInfo);
            if (((ComparableDefaultMutableTreeNode)defaultMutableTreeNode).compareTo((DefaultMutableTreeNode)serializable2) == 0) {
                defaultMutableTreeNode.setUserObject(xNodeInfo);
                serializable = (DefaultTreeModel)this.getModel();
                ((DefaultTreeModel)serializable).nodeChanged(defaultMutableTreeNode);
            } else {
                serializable = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                this.removeChildNode(defaultMutableTreeNode);
                defaultMutableTreeNode.setUserObject(xNodeInfo);
                this.addChildNode((DefaultMutableTreeNode)serializable, defaultMutableTreeNode);
            }
        } else {
            defaultMutableTreeNode.setUserObject(xNodeInfo);
            serializable2 = (DefaultTreeModel)this.getModel();
            ((DefaultTreeModel)serializable2).nodeChanged(defaultMutableTreeNode);
        }
        if (xNodeInfo.getType().equals((Object)XNodeInfo.Type.MBEAN)) {
            this.removeMetadataNodes(defaultMutableTreeNode);
            serializable2 = defaultMutableTreeNode.getPath();
            serializable = new TreePath((Object[])serializable2);
            if (this.isExpanded((TreePath)serializable)) {
                this.addMetadataNodes(defaultMutableTreeNode);
            }
        }
        if (defaultMutableTreeNode == this.getLastSelectedPathComponent()) {
            serializable2 = this.getSelectionPath();
            this.clearSelection();
            this.setSelectionPath((TreePath)serializable2);
        }
    }

    private DefaultMutableTreeNode createDomainNode(Dn dn, Token token) {
        ComparableDefaultMutableTreeNode comparableDefaultMutableTreeNode = new ComparableDefaultMutableTreeNode();
        String string = dn.getDomain();
        XNodeInfo xNodeInfo = new XNodeInfo(XNodeInfo.Type.NONMBEAN, string, string, string);
        comparableDefaultMutableTreeNode.setUserObject(xNodeInfo);
        return comparableDefaultMutableTreeNode;
    }

    private DefaultMutableTreeNode createDnNode(Dn dn, Token token, XMBean xMBean) {
        ComparableDefaultMutableTreeNode comparableDefaultMutableTreeNode = new ComparableDefaultMutableTreeNode();
        Object object = this.createNodeValue(xMBean, token);
        String string = object.toString();
        XNodeInfo xNodeInfo = new XNodeInfo(XNodeInfo.Type.MBEAN, object, string, xMBean.getObjectName().toString());
        comparableDefaultMutableTreeNode.setUserObject(xNodeInfo);
        return comparableDefaultMutableTreeNode;
    }

    private DefaultMutableTreeNode createSubDnNode(Dn dn, Token token) {
        ComparableDefaultMutableTreeNode comparableDefaultMutableTreeNode = new ComparableDefaultMutableTreeNode();
        String string = this.isKeyValueView() ? token.getTokenValue() : token.getValue();
        XNodeInfo xNodeInfo = new XNodeInfo(XNodeInfo.Type.NONMBEAN, string, string, token.getTokenValue());
        comparableDefaultMutableTreeNode.setUserObject(xNodeInfo);
        return comparableDefaultMutableTreeNode;
    }

    private Object createNodeValue(XMBean xMBean, Token token) {
        String string = this.isKeyValueView() ? token.getTokenValue() : token.getValue();
        xMBean.setText(string);
        return xMBean;
    }

    private static Map<String, String> extractKeyValuePairs(String string, ObjectName objectName) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        int n = string.indexOf("=");
        while (n != -1) {
            String string2 = string.substring(0, n);
            String string3 = objectName.getKeyProperty(string2);
            linkedHashMap.put(string2, string3);
            string = string.substring(string2.length() + 1 + string3.length());
            if (string.startsWith(",")) {
                string = string.substring(1);
            }
            n = string.indexOf("=");
        }
        return linkedHashMap;
    }

    private static String getKeyPropertyListString(ObjectName objectName) {
        String string = objectName.getKeyPropertyListString();
        Map<String, String> map = XTree.extractKeyValuePairs(string, objectName);
        StringBuilder stringBuilder = new StringBuilder();
        for (String object : orderedKeyPropertyList) {
            if (!map.containsKey(object)) continue;
            stringBuilder.append(object + "=" + map.get(object) + ",");
            map.remove(object);
        }
        for (Map.Entry entry : map.entrySet()) {
            stringBuilder.append((String)entry.getKey() + "=" + (String)entry.getValue() + ",");
        }
        Object object = stringBuilder.toString();
        object = ((String)object).substring(0, ((String)object).length() - 1);
        return object;
    }

    public void addMetadataNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
        XMBean xMBean = (XMBean)((XNodeInfo)defaultMutableTreeNode.getUserObject()).getData();
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        MBeanInfoNodesSwingWorker mBeanInfoNodesSwingWorker = new MBeanInfoNodesSwingWorker(defaultTreeModel, defaultMutableTreeNode, xMBean);
        if (mBeanInfoNodesSwingWorker != null) {
            mBeanInfoNodesSwingWorker.execute();
        }
    }

    private static boolean isTreeView() {
        if (!treeViewInit) {
            treeView = XTree.getTreeViewValue();
            treeViewInit = true;
        }
        return treeView;
    }

    private static boolean getTreeViewValue() {
        String string = System.getProperty("treeView");
        return string == null ? true : !string.equals("false");
    }

    private boolean isKeyValueView() {
        return this.keyValueView;
    }

    static {
        String string = System.getProperty("com.sun.tools.jconsole.mbeans.keyPropertyList");
        if (string == null) {
            orderedKeyPropertyList.add("type");
            orderedKeyPropertyList.add("j2eeType");
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                orderedKeyPropertyList.add(stringTokenizer.nextToken());
            }
        }
        treeViewInit = false;
    }

    private static class Token {
        private String tokenType;
        private String tokenValue;
        private String key;
        private String value;

        public Token(String string, String string2) {
            this.tokenType = string;
            this.tokenValue = string2;
            this.buildKeyValue();
        }

        public String getTokenType() {
            return this.tokenType;
        }

        public String getTokenValue() {
            return this.tokenValue;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        private void buildKeyValue() {
            int n = this.tokenValue.indexOf("=");
            if (n < 0) {
                this.key = this.tokenValue;
                this.value = this.tokenValue;
            } else {
                this.key = this.tokenValue.substring(0, n);
                this.value = this.tokenValue.substring(n + 1, this.tokenValue.length());
            }
        }
    }

    private static class Dn
    implements Comparable<Dn> {
        private ObjectName mbean;
        private String domain;
        private String keyPropertyList;
        private String hashDn;
        private List<Token> tokens = new ArrayList<Token>();

        public Dn(ObjectName objectName) {
            this.mbean = objectName;
            this.domain = objectName.getDomain();
            this.keyPropertyList = XTree.getKeyPropertyListString(objectName);
            if (XTree.isTreeView()) {
                Map map = XTree.extractKeyValuePairs(this.keyPropertyList, objectName);
                for (Map.Entry entry : map.entrySet()) {
                    this.tokens.add(new Token("key", (String)entry.getKey() + "=" + (String)entry.getValue()));
                }
            } else {
                this.tokens.add(new Token("key", "properties=" + this.keyPropertyList));
            }
            this.tokens.add(0, new Token("domain", "domain=" + this.domain));
            Collections.reverse(this.tokens);
            this.computeHashDn();
        }

        public ObjectName getObjectName() {
            return this.mbean;
        }

        public String getDomain() {
            return this.domain;
        }

        public String getKeyPropertyList() {
            return this.keyPropertyList;
        }

        public Token getToken(int n) {
            return this.tokens.get(n);
        }

        public int getTokenCount() {
            return this.tokens.size();
        }

        public String getHashDn() {
            return this.hashDn;
        }

        public String getHashKey(Token token) {
            int n = this.hashDn.indexOf(token.getTokenValue());
            return this.hashDn.substring(n, this.hashDn.length());
        }

        private void computeHashDn() {
            if (this.tokens.isEmpty()) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.tokens.size(); ++i) {
                stringBuilder.append(this.tokens.get(i).getTokenValue());
                stringBuilder.append(",");
            }
            this.hashDn = stringBuilder.substring(0, stringBuilder.length() - 1);
        }

        public String toString() {
            return this.domain + ":" + this.keyPropertyList;
        }

        @Override
        public int compareTo(Dn dn) {
            return this.toString().compareTo(dn.toString());
        }
    }

    private static class ComparableDefaultMutableTreeNode
    extends DefaultMutableTreeNode
    implements Comparable<DefaultMutableTreeNode> {
        private ComparableDefaultMutableTreeNode() {
        }

        @Override
        public int compareTo(DefaultMutableTreeNode defaultMutableTreeNode) {
            return this.toString().compareTo(defaultMutableTreeNode.toString());
        }
    }

    private static class MBeanInfoNodesSwingWorker
    extends SwingWorker<Object[], Void> {
        private final DefaultTreeModel model;
        private final DefaultMutableTreeNode node;
        private final XMBean mbean;

        public MBeanInfoNodesSwingWorker(DefaultTreeModel defaultTreeModel, DefaultMutableTreeNode defaultMutableTreeNode, XMBean xMBean) {
            this.model = defaultTreeModel;
            this.node = defaultMutableTreeNode;
            this.mbean = xMBean;
        }

        @Override
        public Object[] doInBackground() throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
            Object[] objectArray = new Object[]{this.mbean.getMBeanInfo(), this.mbean.isBroadcaster()};
            return objectArray;
        }

        @Override
        protected void done() {
            block3: {
                try {
                    Object[] objectArray = (Object[])this.get();
                    MBeanInfo mBeanInfo = (MBeanInfo)objectArray[0];
                    Boolean bl = (Boolean)objectArray[1];
                    if (mBeanInfo != null) {
                        this.addMBeanInfoNodes(this.model, this.node, this.mbean, mBeanInfo, bl);
                    }
                }
                catch (Exception exception) {
                    Throwable throwable = Utils.getActualException(exception);
                    if (!JConsole.isDebug()) break block3;
                    throwable.printStackTrace();
                }
            }
        }

        private void addMBeanInfoNodes(DefaultTreeModel defaultTreeModel, DefaultMutableTreeNode defaultMutableTreeNode, XMBean xMBean, MBeanInfo mBeanInfo, Boolean bl) {
            Object object;
            Serializable serializable;
            XNodeInfo xNodeInfo;
            DefaultMutableTreeNode defaultMutableTreeNode2;
            MBeanAttributeInfo[] mBeanAttributeInfoArray = mBeanInfo.getAttributes();
            MBeanOperationInfo[] mBeanOperationInfoArray = mBeanInfo.getOperations();
            MBeanNotificationInfo[] mBeanNotificationInfoArray = mBeanInfo.getNotifications();
            int n = 0;
            if (mBeanAttributeInfoArray != null && mBeanAttributeInfoArray.length > 0) {
                defaultMutableTreeNode2 = new DefaultMutableTreeNode();
                xNodeInfo = new XNodeInfo(XNodeInfo.Type.ATTRIBUTES, xMBean, Resources.getText("Attributes", new Object[0]), null);
                defaultMutableTreeNode2.setUserObject(xNodeInfo);
                defaultMutableTreeNode.insert(defaultMutableTreeNode2, n++);
                for (MBeanFeatureInfo mBeanFeatureInfo : mBeanAttributeInfoArray) {
                    serializable = new DefaultMutableTreeNode();
                    object = new XNodeInfo(XNodeInfo.Type.ATTRIBUTE, new Object[]{xMBean, mBeanFeatureInfo}, mBeanFeatureInfo.getName(), null);
                    ((DefaultMutableTreeNode)serializable).setUserObject(object);
                    ((DefaultMutableTreeNode)serializable).setAllowsChildren(false);
                    defaultMutableTreeNode2.add((MutableTreeNode)((Object)serializable));
                }
            }
            if (mBeanOperationInfoArray != null && mBeanOperationInfoArray.length > 0) {
                defaultMutableTreeNode2 = new DefaultMutableTreeNode();
                xNodeInfo = new XNodeInfo(XNodeInfo.Type.OPERATIONS, xMBean, Resources.getText("Operations", new Object[0]), null);
                defaultMutableTreeNode2.setUserObject(xNodeInfo);
                defaultMutableTreeNode.insert(defaultMutableTreeNode2, n++);
                for (MBeanFeatureInfo mBeanFeatureInfo : mBeanOperationInfoArray) {
                    serializable = new StringBuilder();
                    for (MBeanParameterInfo mBeanParameterInfo : ((MBeanOperationInfo)mBeanFeatureInfo).getSignature()) {
                        ((StringBuilder)serializable).append(mBeanParameterInfo.getType() + ",");
                    }
                    object = ((StringBuilder)serializable).toString();
                    if (((String)object).length() > 0) {
                        object = ((String)object).substring(0, ((String)object).length() - 1);
                    }
                    String string = mBeanFeatureInfo.getName() + "(" + (String)object + ")";
                    DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode();
                    XNodeInfo xNodeInfo2 = new XNodeInfo(XNodeInfo.Type.OPERATION, new Object[]{xMBean, mBeanFeatureInfo}, mBeanFeatureInfo.getName(), string);
                    defaultMutableTreeNode3.setUserObject(xNodeInfo2);
                    defaultMutableTreeNode3.setAllowsChildren(false);
                    defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                }
            }
            if (bl != null && bl.booleanValue()) {
                defaultMutableTreeNode2 = new DefaultMutableTreeNode();
                xNodeInfo = new XNodeInfo(XNodeInfo.Type.NOTIFICATIONS, xMBean, Resources.getText("Notifications", new Object[0]), null);
                defaultMutableTreeNode2.setUserObject(xNodeInfo);
                defaultMutableTreeNode.insert(defaultMutableTreeNode2, n++);
                if (mBeanNotificationInfoArray != null && mBeanNotificationInfoArray.length > 0) {
                    for (MBeanFeatureInfo mBeanFeatureInfo : mBeanNotificationInfoArray) {
                        serializable = new DefaultMutableTreeNode();
                        object = new XNodeInfo(XNodeInfo.Type.NOTIFICATION, mBeanFeatureInfo, mBeanFeatureInfo.getName(), null);
                        ((DefaultMutableTreeNode)serializable).setUserObject(object);
                        ((DefaultMutableTreeNode)serializable).setAllowsChildren(false);
                        defaultMutableTreeNode2.add((MutableTreeNode)((Object)serializable));
                    }
                }
            }
            this.model.reload(defaultMutableTreeNode);
        }
    }
}

