/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.packager.bundlers;

import com.sun.javafx.tools.packager.Log;
import com.sun.javafx.tools.packager.bundlers.BundleParams;
import com.sun.javafx.tools.packager.bundlers.Bundler;
import com.sun.javafx.tools.packager.bundlers.IOUtils;
import com.sun.javafx.tools.resource.windows.WinResources;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.Set;

public class WinAppBundler
extends Bundler {
    private BundleParams params;
    private File rootDirectory;
    private File configRoot;
    private static final String EXECUTABLE_NAME = "WinLauncher.exe";
    private static final String TOOL_ICON_SWAP = "IconSwap.exe";
    public static final String WIN_BUNDLER_PREFIX = "package/windows/";
    private static final String TEMPLATE_APP_ICON = "javalogo_white_48.ico";

    public WinAppBundler() {
        this.baseResourceLoader = WinResources.class;
    }

    protected void setBuildRoot(File dir) {
        super.setBuildRoot(dir);
        this.configRoot = new File(dir, "windows");
        this.configRoot.mkdirs();
    }

    boolean validate(BundleParams p) throws Bundler.UnsupportedPlatformException, Bundler.ConfigException {
        if (p.type != Bundler.BundleType.ALL && p.type != Bundler.BundleType.IMAGE) {
            return false;
        }
        return this.doValidate(p);
    }

    boolean doValidate(BundleParams p) throws Bundler.UnsupportedPlatformException, Bundler.ConfigException {
        if (!System.getProperty("os.name").toLowerCase().startsWith("win")) {
            throw new Bundler.UnsupportedPlatformException();
        }
        if (WinResources.class.getResource(EXECUTABLE_NAME) == null) {
            throw new Bundler.ConfigException("This copy of ant-javafx.jar does not support Windows.", "Please use ant-javafx.jar coming with Oracle JDK for Windows.");
        }
        if (p.getMainApplicationJar() == null) {
            throw new Bundler.ConfigException("Main application jar is missing.", "Make sure to use fx:jar task to create main application jar.");
        }
        this.testRuntime(p, "lib\\jfxrt.jar");
        return true;
    }

    static String getAppName(BundleParams p) {
        String nm = p.name != null ? p.name : p.getMainClassName();
        return nm;
    }

    private static File getRootDir(File outDir, BundleParams p) {
        return new File(outDir, WinAppBundler.getAppName(p));
    }

    public static File getLauncher(File outDir, BundleParams p) {
        return new File(WinAppBundler.getRootDir(outDir, p), WinAppBundler.getAppName(p) + ".exe");
    }

    private File getConfig_AppIcon() {
        return new File(this.configRoot, WinAppBundler.getAppName(this.params) + ".ico");
    }

    protected void cleanupConfigFiles() {
        if (this.getConfig_AppIcon() != null) {
            this.getConfig_AppIcon().delete();
        }
    }

    private void prepareConfigFiles() throws IOException {
        File iconTarget = this.getConfig_AppIcon();
        if (this.params.icon != null) {
            this.fetchResource(WIN_BUNDLER_PREFIX + iconTarget.getName(), "application icon", this.params.icon, iconTarget);
        } else {
            this.fetchResource(WIN_BUNDLER_PREFIX + iconTarget.getName(), "application icon", TEMPLATE_APP_ICON, iconTarget);
        }
    }

    public boolean bundle(BundleParams p, File outputDirectory) {
        return this.doBundle(p, outputDirectory, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean doBundle(BundleParams p, File outputDirectory, boolean dependentTask) {
        block10: {
            try {
                try {
                    this.params = p;
                    if (!dependentTask) {
                        Log.info("Creating app bundle: " + WinAppBundler.getAppName(p) + " in " + outputDirectory.getAbsolutePath());
                    }
                    this.prepareConfigFiles();
                    this.rootDirectory = WinAppBundler.getRootDir(outputDirectory, p);
                    IOUtils.deleteRecursive(this.rootDirectory);
                    this.rootDirectory.mkdirs();
                    File appDirectory = new File(this.rootDirectory, "app");
                    appDirectory.mkdirs();
                    this.copyApplication(appDirectory);
                    File pkgInfoFile = new File(appDirectory, "package.cfg");
                    pkgInfoFile.createNewFile();
                    this.writePkgInfo(pkgInfoFile);
                    File executableFile = WinAppBundler.getLauncher(outputDirectory, p);
                    IOUtils.copyFromURL(WinResources.class.getResource(EXECUTABLE_NAME), executableFile);
                    executableFile.setExecutable(true, false);
                    if (this.getConfig_AppIcon().exists()) {
                        File iconSwapTool = File.createTempFile("iconswap", ".exe");
                        iconSwapTool.delete();
                        IOUtils.copyFromURL(WinResources.class.getResource(TOOL_ICON_SWAP), iconSwapTool);
                        iconSwapTool.setExecutable(true, false);
                        iconSwapTool.deleteOnExit();
                        executableFile.setWritable(true);
                        ProcessBuilder pb = new ProcessBuilder(iconSwapTool.getAbsolutePath(), this.getConfig_AppIcon().getAbsolutePath(), executableFile.getAbsolutePath());
                        IOUtils.exec(pb, this.verbose);
                        executableFile.setReadOnly();
                        iconSwapTool.delete();
                    }
                    File runtimeDirectory = new File(this.rootDirectory, "runtime");
                    runtimeDirectory.mkdirs();
                    this.copyRuntime(runtimeDirectory);
                    IOUtils.copyFile(this.getConfig_AppIcon(), new File(WinAppBundler.getRootDir(outputDirectory, p), WinAppBundler.getAppName(p) + ".ico"));
                    if (!dependentTask) {
                        Log.info("Result application bundle: " + outputDirectory.getAbsolutePath());
                    }
                }
                catch (IOException ex) {
                    System.out.println("Exception: " + ex);
                    ex.printStackTrace();
                    boolean bl = false;
                    Object var10_12 = null;
                    if (this.verbose) {
                        Log.info("  Config files are saved to " + this.configRoot.getAbsolutePath() + ". Use them to customize package.");
                        return bl;
                    }
                    this.cleanupConfigFiles();
                    return bl;
                }
                Object var10_11 = null;
                if (!this.verbose) break block10;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                if (this.verbose) {
                    Log.info("  Config files are saved to " + this.configRoot.getAbsolutePath() + ". Use them to customize package.");
                    throw throwable;
                }
                this.cleanupConfigFiles();
                throw throwable;
            }
            Log.info("  Config files are saved to " + this.configRoot.getAbsolutePath() + ". Use them to customize package.");
            return true;
        }
        this.cleanupConfigFiles();
        return true;
    }

    public String toString() {
        return "Windows Application Bundler";
    }

    private void copyApplication(File appDirectory) throws IOException {
        if (this.params.appResources == null) {
            throw new RuntimeException("Null app resources?");
        }
        File srcdir = this.params.appResources.getBaseDirectory();
        for (String fname : this.params.appResources.getIncludedFiles()) {
            IOUtils.copyFile(new File(srcdir, fname), new File(appDirectory, fname));
        }
    }

    private void writePkgInfo(File pkgInfoFile) throws FileNotFoundException {
        pkgInfoFile.delete();
        PrintStream out = new PrintStream(pkgInfoFile);
        out.println("mainjar=" + this.params.getMainApplicationJar());
        out.println("version=" + this.params.appVersion);
        out.println("app.id=" + this.params.identifier);
        List<String> jvmargs = this.params.getAllJvmOptions();
        int idx = 1;
        for (String a : jvmargs) {
            out.println("jvmarg." + idx + "=" + a);
            ++idx;
        }
        out.close();
    }

    private void copyRuntime(File runtimeDirectory) throws IOException {
        File srcdir = this.params.runtime.getBaseDirectory();
        File destDir = new File(runtimeDirectory, srcdir.getName());
        Set<String> filesToCopy = this.params.runtime.getIncludedFiles();
        for (String fname : filesToCopy) {
            IOUtils.copyFile(new File(srcdir, fname), new File(destDir, fname));
        }
    }
}

