/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.packager.bundlers;

import com.sun.javafx.tools.packager.Log;
import com.sun.javafx.tools.packager.bundlers.BundleParams;
import com.sun.javafx.tools.packager.bundlers.Bundler;
import com.sun.javafx.tools.packager.bundlers.IOUtils;
import com.sun.javafx.tools.packager.bundlers.LinuxAppBundler;
import com.sun.javafx.tools.resource.linux.LinuxResources;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;

public class LinuxDebBundler
extends Bundler {
    LinuxAppBundler appBundler = new LinuxAppBundler();
    BundleParams params;
    private File configRoot = null;
    File imageDir = null;
    File configDir = null;
    File appImageRoot = null;
    private boolean menuShortcut = false;
    private boolean desktopShortcut = false;
    private static final String DEFAULT_ICON = "javalogo_white_32.png";
    private static final String DEFAULT_CONTROL_TEMPLATE = "template.control";
    private static final String DEFAULT_POSTRM_TEMPLATE = "template.postrm";
    private static final String DEFAULT_POSTINSTALL_TEMPLATE = "template.postinst";
    private static final String DEFAULT_COPYRIGHT_TEMPLATE = "template.copyright";
    private static final String DEFAULT_DESKTOP_FILE_TEMPLATE = "template.desktop";
    private static final String TOOL_DPKG = "dpkg-deb";

    public LinuxDebBundler() {
        this.baseResourceLoader = LinuxResources.class;
    }

    protected void setBuildRoot(File dir) {
        super.setBuildRoot(dir);
        this.configRoot = new File(dir, "linux");
        this.configRoot.mkdirs();
        this.appBundler.setBuildRoot(dir);
    }

    public void setVerbose(boolean m) {
        super.setVerbose(m);
        this.appBundler.setVerbose(m);
    }

    private boolean testTool(String toolName, String minVersion) {
        try {
            ProcessBuilder pb = new ProcessBuilder(toolName, "--version");
            IOUtils.exec(pb, Log.isDebug(), true);
        }
        catch (Exception e) {
            Log.verbose("Test for [" + toolName + "]. Result: " + e.getMessage());
            return false;
        }
        return true;
    }

    boolean validate(BundleParams p) throws Bundler.UnsupportedPlatformException, Bundler.ConfigException {
        if (p.type != Bundler.BundleType.ALL && p.type != Bundler.BundleType.INSTALLER || p.bundleFormat != null && !"deb".equals(p.bundleFormat)) {
            return false;
        }
        this.appBundler.doValidate(p);
        if (!this.testTool(TOOL_DPKG, "1")) {
            throw new Bundler.ConfigException("Can not find dpkg-deb.", "  Please install required packages.");
        }
        return true;
    }

    private boolean prepareProto() {
        return this.appBundler.doBundle(this.params, this.appImageRoot, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean bundle(BundleParams p, File outdir) {
        this.params = p;
        String packageName = this.getFullPackageName();
        this.imageDir = new File(new File(this.imagesRoot, "linux-deb.image"), packageName);
        this.configDir = new File(this.imageDir, "DEBIAN");
        this.configDir.mkdirs();
        this.appImageRoot = new File(this.imageDir, "opt");
        try {
            this.imageDir.mkdirs();
            this.menuShortcut = this.params.needMenu;
            this.desktopShortcut = this.params.needShortcut;
            if (!this.menuShortcut && !this.desktopShortcut) {
                Log.verbose("At least one type of shortcut is required. Enabling menu shortcut.");
                this.menuShortcut = true;
            }
            if (this.prepareProto() && this.prepareProjectConfig()) {
                boolean bl = this.buildDeb(outdir);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (this.verbose) {
                    this.saveConfigFiles();
                }
                if (this.imageDir != null && !Log.isDebug()) {
                    IOUtils.deleteRecursive(this.imageDir);
                } else if (this.imageDir != null) {
                    Log.info("Kept working directory for debug: " + this.imageDir.getAbsolutePath());
                }
            }
            catch (FileNotFoundException ex) {
                return false;
            }
        }
    }

    protected void saveConfigFiles() {
        try {
            if (this.getConfig_ControlFile().exists()) {
                IOUtils.copyFile(this.getConfig_ControlFile(), new File(this.configRoot, this.getConfig_ControlFile().getName()));
            }
            if (this.getConfig_CopyrightFile().exists()) {
                IOUtils.copyFile(this.getConfig_CopyrightFile(), new File(this.configRoot, this.getConfig_CopyrightFile().getName()));
            }
            if (this.getConfig_PostinstallFile().exists()) {
                IOUtils.copyFile(this.getConfig_PostinstallFile(), new File(this.configRoot, this.getConfig_PostinstallFile().getName()));
            }
            if (this.getConfig_PostrmFile().exists()) {
                IOUtils.copyFile(this.getConfig_PostrmFile(), new File(this.configRoot, this.getConfig_PostrmFile().getName()));
            }
            if (this.getConfig_DesktopShortcutFile().exists()) {
                IOUtils.copyFile(this.getConfig_DesktopShortcutFile(), new File(this.configRoot, this.getConfig_DesktopShortcutFile().getName()));
            }
            if (this.getConfig_IconFile().exists()) {
                IOUtils.copyFile(this.getConfig_IconFile(), new File(this.configRoot, this.getConfig_IconFile().getName()));
            }
            Log.info("  Config files are saved to " + this.configRoot.getAbsolutePath() + ". Use them to customize package.");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public String toString() {
        return "DEB bundler";
    }

    private String getFullPackageName() {
        return this.getBundleName() + "-" + this.getVersion();
    }

    private String getBundleName() {
        String nm = this.params.name != null ? this.params.name : this.params.getMainClassName();
        nm = nm.replaceAll(" ", "");
        return nm;
    }

    private String getVersion() {
        if (this.params.appVersion != null) {
            return this.params.appVersion;
        }
        return "1.0";
    }

    private String getArch() {
        String arch = System.getProperty("os.arch");
        if ("i386".equals(arch)) {
            return "i386";
        }
        return "amd64";
    }

    private String getLicenseText() {
        try {
            if (this.params.licenseFile.isEmpty()) {
                if (this.params.licenseType != null) {
                    return this.params.licenseType;
                }
                return "Unknown";
            }
            File appdir = new File(LinuxAppBundler.getLauncher(this.appImageRoot, this.params).getParentFile(), "app");
            return new String(IOUtils.readFully(new File(appdir, this.params.licenseFile.get(0))));
        }
        catch (Exception e) {
            if (Log.isDebug()) {
                e.printStackTrace();
            }
            if (this.params.licenseType != null) {
                return this.params.licenseType;
            }
            return "Unknown";
        }
    }

    private boolean prepareProjectConfig() throws IOException {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("APPLICATION_NAME", this.getBundleName());
        data.put("APPLICATION_VENDOR", this.params.vendor != null ? this.params.vendor : "Unknown");
        data.put("APPLICATION_VERSION", this.getVersion());
        data.put("APPLICATION_LAUNCHER_FILENAME", LinuxAppBundler.getLauncher(this.imageDir, this.params).getName());
        data.put("DEPLOY_BUNDLE_CATEGORY", this.params.applicationCategory != null ? this.params.applicationCategory : "Applications;");
        data.put("APPLICATION_DESCRIPTION", this.params.description != null ? this.params.description : this.params.name);
        data.put("APPLICATION_SUMMARY", this.params.title != null ? this.params.title : this.params.name);
        data.put("APPLICATION_COPYRIGHT", this.params.copyright != null ? this.params.copyright : "Unknown");
        data.put("APPLICATION_LICENSE_TYPE", this.params.licenseType != null ? this.params.licenseType : "unknown");
        data.put("APPLICATION_LICENSE_TEXT", this.getLicenseText());
        data.put("APPLICATION_ARCH", this.getArch());
        BufferedWriter w = new BufferedWriter(new FileWriter(this.getConfig_ControlFile()));
        String content = this.preprocessTextResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + this.getConfig_ControlFile().getName(), "DEB control file", DEFAULT_CONTROL_TEMPLATE, data);
        w.write(content);
        ((Writer)w).close();
        w = new BufferedWriter(new FileWriter(this.getConfig_PostinstallFile()));
        content = this.preprocessTextResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + this.getConfig_PostinstallFile().getName(), "DEB postinstall script", DEFAULT_POSTINSTALL_TEMPLATE, data);
        w.write(content);
        ((Writer)w).close();
        this.getConfig_PostinstallFile().setExecutable(true, false);
        w = new BufferedWriter(new FileWriter(this.getConfig_PostrmFile()));
        content = this.preprocessTextResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + this.getConfig_PostrmFile().getName(), "DEB postinstall script", DEFAULT_POSTRM_TEMPLATE, data);
        w.write(content);
        ((Writer)w).close();
        this.getConfig_PostrmFile().setExecutable(true, false);
        w = new BufferedWriter(new FileWriter(this.getConfig_CopyrightFile()));
        content = this.preprocessTextResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + this.getConfig_CopyrightFile().getName(), "DEB copyright file", DEFAULT_COPYRIGHT_TEMPLATE, data);
        w.write(content);
        ((Writer)w).close();
        w = new BufferedWriter(new FileWriter(this.getConfig_DesktopShortcutFile()));
        content = this.preprocessTextResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + this.getConfig_DesktopShortcutFile().getName(), "Menu shortcut descriptor", DEFAULT_DESKTOP_FILE_TEMPLATE, data);
        w.write(content);
        ((Writer)w).close();
        File iconTarget = this.getConfig_IconFile();
        if (this.params.icon == null) {
            this.fetchResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + iconTarget.getName(), "menu icon", DEFAULT_ICON, iconTarget);
        } else {
            this.fetchResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + iconTarget.getName(), "menu icon", this.params.icon, iconTarget);
        }
        return true;
    }

    private File getConfig_DesktopShortcutFile() {
        return new File(LinuxAppBundler.getLauncher(this.appImageRoot, this.params).getParentFile(), this.getBundleName() + ".desktop");
    }

    private File getConfig_IconFile() {
        return new File(LinuxAppBundler.getLauncher(this.appImageRoot, this.params).getParentFile(), this.getBundleName() + ".png");
    }

    private File getConfig_ControlFile() {
        return new File(this.configDir, "control");
    }

    private File getConfig_PostinstallFile() {
        return new File(this.configDir, "postinst");
    }

    private File getConfig_PostrmFile() {
        return new File(this.configDir, "postrm");
    }

    private File getConfig_CopyrightFile() {
        return new File(this.configDir, "copyright");
    }

    private boolean buildDeb(File outdir) throws IOException {
        File outFile = new File(outdir, this.getFullPackageName() + ".deb");
        Log.verbose("Generating DEB for installer to: " + outFile.getAbsolutePath());
        outFile.getParentFile().mkdirs();
        ProcessBuilder pb = new ProcessBuilder(TOOL_DPKG, "-b", this.getFullPackageName(), outFile.getAbsolutePath());
        pb = pb.directory(this.imageDir.getParentFile());
        IOUtils.exec(pb, this.verbose);
        Log.info("Package (.deb) saved to: " + outFile.getAbsolutePath());
        return true;
    }
}

