/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.action;

import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public final class PanAction
extends WidgetAction.LockedAdapter {
    private Scene scene;
    private JScrollPane scrollPane;
    private Point lastLocation;

    @Override
    protected boolean isLocked() {
        return this.scrollPane != null;
    }

    @Override
    public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        if (this.isLocked()) {
            return WidgetAction.State.createLocked(widget, this);
        }
        if (widgetMouseEvent.getButton() == 2) {
            this.scene = widget.getScene();
            this.scrollPane = this.findScrollPane(this.scene.getView());
            if (this.scrollPane != null) {
                this.lastLocation = this.scene.convertSceneToView(widget.convertLocalToScene(widgetMouseEvent.getPoint()));
                SwingUtilities.convertPointToScreen(this.lastLocation, this.scene.getView());
                return WidgetAction.State.createLocked(widget, this);
            }
        }
        return WidgetAction.State.REJECTED;
    }

    private JScrollPane findScrollPane(JComponent jComponent) {
        while (jComponent != null) {
            if (jComponent instanceof JScrollPane) {
                return (JScrollPane)jComponent;
            }
            Container container = jComponent.getParent();
            if (!(container instanceof JComponent)) {
                return null;
            }
            jComponent = (JComponent)container;
        }
        return null;
    }

    @Override
    public WidgetAction.State mouseReleased(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        boolean bl = this.pan(widget, widgetMouseEvent.getPoint());
        if (bl) {
            this.scrollPane = null;
        }
        return bl ? WidgetAction.State.createLocked(widget, this) : WidgetAction.State.REJECTED;
    }

    @Override
    public WidgetAction.State mouseDragged(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        return this.pan(widget, widgetMouseEvent.getPoint()) ? WidgetAction.State.createLocked(widget, this) : WidgetAction.State.REJECTED;
    }

    private boolean pan(Widget widget, Point point) {
        if (this.scrollPane == null || this.scene != widget.getScene()) {
            return false;
        }
        point = this.scene.convertSceneToView(widget.convertLocalToScene(point));
        SwingUtilities.convertPointToScreen(point, this.scene.getView());
        JComponent jComponent = this.scene.getView();
        Rectangle rectangle = jComponent.getVisibleRect();
        rectangle.x += this.lastLocation.x - point.x;
        rectangle.y += this.lastLocation.y - point.y;
        jComponent.scrollRectToVisible(rectangle);
        this.lastLocation = point;
        return true;
    }
}

