/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.openide.awt.StatusDisplayer;
import org.openide.util.ChangeSupport;
import org.openide.util.RequestProcessor;

public final class NbStatusDisplayer
extends StatusDisplayer {
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private List<WeakReference<MessageImpl>> messages = new ArrayList<WeakReference<MessageImpl>>(30);
    private static int SURVIVING_TIME = Integer.getInteger("org.openide.awt.StatusDisplayer.DISPLAY_TIME", 5000);
    private static final RequestProcessor RP = new RequestProcessor("NbStatusDisplayer");

    public void setStatusText(String string) {
        this.add(string, 0).clear(SURVIVING_TIME);
    }

    public StatusDisplayer.Message setStatusText(String string, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid importance value: " + n);
        }
        return this.add(string, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getStatusText() {
        String string = null;
        NbStatusDisplayer nbStatusDisplayer = this;
        synchronized (nbStatusDisplayer) {
            MessageImpl messageImpl = this.getCurrent();
            string = null == messageImpl ? "" : messageImpl.text;
        }
        return string;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.cs.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.cs.removeChangeListener(changeListener);
    }

    private MessageImpl getCurrent() {
        while (!this.messages.isEmpty()) {
            WeakReference<MessageImpl> weakReference = this.messages.get(0);
            MessageImpl messageImpl = (MessageImpl)weakReference.get();
            if (null != messageImpl) {
                return messageImpl;
            }
            this.messages.remove(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessageImpl add(String string, int n) {
        MessageImpl messageImpl = new MessageImpl(string, n);
        WeakReference<MessageImpl> weakReference = new WeakReference<MessageImpl>(messageImpl);
        NbStatusDisplayer nbStatusDisplayer = this;
        synchronized (nbStatusDisplayer) {
            boolean bl = false;
            for (int i = 0; i < this.messages.size() && !bl; ++i) {
                WeakReference<MessageImpl> weakReference2 = this.messages.get(0);
                MessageImpl messageImpl2 = (MessageImpl)weakReference2.get();
                if (messageImpl2 == null) continue;
                if (messageImpl2.importance == n) {
                    this.messages.set(i, weakReference);
                    bl = true;
                    continue;
                }
                if (messageImpl2.importance >= n) continue;
                this.messages.add(i, weakReference);
                bl = true;
            }
            if (!bl) {
                this.messages.add(weakReference);
            }
        }
        this.cs.fireChange();
        Logger.getLogger(NbStatusDisplayer.class.getName()).log(Level.FINE, "Status text updated: {0}, importance: {1}", new Object[]{string, n});
        return messageImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(MessageImpl messageImpl) {
        NbStatusDisplayer nbStatusDisplayer = this;
        synchronized (nbStatusDisplayer) {
            WeakReference<MessageImpl> weakReference = null;
            for (WeakReference<MessageImpl> weakReference2 : this.messages) {
                if (messageImpl != weakReference2.get()) continue;
                weakReference = weakReference2;
                break;
            }
            if (null != weakReference) {
                this.messages.remove(weakReference);
            }
        }
        this.cs.fireChange();
    }

    private class MessageImpl
    implements StatusDisplayer.Message,
    Runnable {
        private final String text;
        private final int importance;

        public MessageImpl(String string, int n) {
            this.text = string;
            this.importance = n;
        }

        public void clear(int n) {
            RP.post((Runnable)this, n);
        }

        protected void finalize() throws Throwable {
            this.run();
        }

        @Override
        public void run() {
            NbStatusDisplayer.this.remove(this);
        }
    }
}

