/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import org.openqa.selenium.server.DefaultRemoteCommand;
import org.openqa.selenium.server.RemoteCommand;
import org.openqa.selenium.server.SeleniumServer;
import org.openqa.selenium.server.browserlaunchers.BrowserLauncher;

public class MockBrowserLauncher
implements BrowserLauncher,
Runnable {
    private final int port;
    private final String sessionId;
    private Thread browser;
    private boolean interrupted = false;

    public MockBrowserLauncher(int port, String sessionId) {
        this.port = port;
        this.sessionId = sessionId;
    }

    public MockBrowserLauncher(int port, String sessionId, String command) {
        this.port = port;
        this.sessionId = sessionId;
    }

    public void launchRemoteSession(String url, boolean multiWindow) {
        this.browser = new Thread(this);
        this.browser.setName("mockbrowser");
        this.browser.start();
    }

    public void launchHTMLSuite(String startURL, String suiteUrl, boolean multiWindow) {
    }

    public void close() {
        this.interrupted = true;
        this.browser.interrupt();
    }

    public void run() {
        try {
            String startURL = "http://localhost:" + this.port + "/selenium-server/driver/?sessionId=" + this.sessionId;
            String commandLine = this.doBrowserRequest(startURL + "&seleniumStart=true", "START");
            while (!this.interrupted) {
                System.out.println("MOCK: " + commandLine);
                RemoteCommand sc = DefaultRemoteCommand.parse(commandLine);
                String result = this.doCommand(sc);
                if (SeleniumServer.isDebugMode() && !this.interrupted) {
                    for (int i = 0; i < 3; ++i) {
                        this.doBrowserRequest(startURL + "&logging=true", "logLevel=debug:dummy log message " + i + "\n");
                    }
                }
                if (this.interrupted) continue;
                commandLine = this.doBrowserRequest(startURL, result);
            }
            System.out.println("MOCK: interrupted, exiting");
        }
        catch (Exception e) {
            RuntimeException re = new RuntimeException("Exception in mock browser", e);
            re.printStackTrace();
            throw re;
        }
    }

    private String doCommand(RemoteCommand sc) {
        String command = sc.getCommand();
        String result = "OK";
        if (command.equals("getAllButtons")) {
            result = "OK,";
        } else if (command.equals("getAllLinks")) {
            result = "OK,1";
        } else if (command.equals("getAllFields")) {
            result = "OK,1,2,3";
        } else if (command.startsWith("get")) {
            result = "OK,x";
        } else if (command.startsWith("is")) {
            result = "OK,true";
        }
        return result;
    }

    private String stringContentsOfInputStream(InputStream is) throws IOException {
        int c;
        StringBuffer sb = new StringBuffer();
        InputStreamReader r = new InputStreamReader(is, "UTF-8");
        while ((c = r.read()) != -1) {
            sb.append((char)c);
        }
        return sb.toString();
    }

    private String doBrowserRequest(String url, String body) throws IOException {
        int responsecode = 200;
        URL result = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)result.openConnection();
        conn.setRequestProperty("Content-Type", "application/xml");
        conn.setDoOutput(true);
        OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
        wr.write(body);
        wr.flush();
        wr.close();
        if (responsecode == 301) {
            String pathToServlet = conn.getRequestProperty("Location");
            throw new RuntimeException("Bug! 301 redirect??? " + pathToServlet);
        }
        if (responsecode != 200) {
            throw new RuntimeException(conn.getResponseMessage());
        }
        InputStream is = conn.getInputStream();
        return this.stringContentsOfInputStream(is);
    }
}

