# Generated by default/object.tt
package Paws::AccessAnalyzer::CloudTrailProperties;
  use Moose;
  has EndTime => (is => 'ro', isa => 'Str', request_name => 'endTime', traits => ['NameInRequest'], required => 1);
  has StartTime => (is => 'ro', isa => 'Str', request_name => 'startTime', traits => ['NameInRequest'], required => 1);
  has TrailProperties => (is => 'ro', isa => 'ArrayRef[Paws::AccessAnalyzer::TrailProperties]', request_name => 'trailProperties', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AccessAnalyzer::CloudTrailProperties

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AccessAnalyzer::CloudTrailProperties object:

  $service_obj->Method(Att1 => { EndTime => $value, ..., TrailProperties => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AccessAnalyzer::CloudTrailProperties object:

  $result = $service_obj->Method(...);
  $result->Att1->EndTime

=head1 DESCRIPTION

Contains information about CloudTrail access.

=head1 ATTRIBUTES


=head2 B<REQUIRED> EndTime => Str

The end of the time range for which Access Analyzer reviews your
CloudTrail events. Events with a timestamp after this time are not
considered to generate a policy. If this is not included in the
request, the default value is the current time.


=head2 B<REQUIRED> StartTime => Str

The start of the time range for which Access Analyzer reviews your
CloudTrail events. Events with a timestamp before this time are not
considered to generate a policy.


=head2 B<REQUIRED> TrailProperties => ArrayRef[L<Paws::AccessAnalyzer::TrailProperties>]

A C<TrailProperties> object that contains settings for trail
properties.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AccessAnalyzer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

