/* rygel-mp2ts-transcoder.c generated by valac 0.20.1, the Vala compiler
 * generated from rygel-mp2ts-transcoder.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-server.h>
#include <gst/pbutils/codec-utils.h>
#include <gst/pbutils/descriptions.h>
#include <gst/pbutils/encoding-profile.h>
#include <gst/pbutils/encoding-target.h>
#include <gst/pbutils/gstdiscoverer.h>
#include <gst/pbutils/gstpluginsbaseversion.h>
#include <gst/pbutils/install-plugins.h>
#include <gst/pbutils/missing-plugins.h>
#include <gst/pbutils/pbutils-enumtypes.h>
#include <gst/pbutils/pbutils.h>
#include <gst/gst.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TYPE_MP2_TS_PROFILE (rygel_mp2_ts_profile_get_type ())

#define RYGEL_TYPE_GST_TRANSCODER (rygel_gst_transcoder_get_type ())
#define RYGEL_GST_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoder))
#define RYGEL_GST_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoderClass))
#define RYGEL_IS_GST_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_GST_TRANSCODER))
#define RYGEL_IS_GST_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_GST_TRANSCODER))
#define RYGEL_GST_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoderClass))

typedef struct _RygelGstTranscoder RygelGstTranscoder;
typedef struct _RygelGstTranscoderClass RygelGstTranscoderClass;
typedef struct _RygelGstTranscoderPrivate RygelGstTranscoderPrivate;

#define RYGEL_TYPE_AUDIO_TRANSCODER (rygel_audio_transcoder_get_type ())
#define RYGEL_AUDIO_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_TRANSCODER, RygelAudioTranscoder))
#define RYGEL_AUDIO_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_TRANSCODER, RygelAudioTranscoderClass))
#define RYGEL_IS_AUDIO_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_TRANSCODER))
#define RYGEL_IS_AUDIO_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_TRANSCODER))
#define RYGEL_AUDIO_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_TRANSCODER, RygelAudioTranscoderClass))

typedef struct _RygelAudioTranscoder RygelAudioTranscoder;
typedef struct _RygelAudioTranscoderClass RygelAudioTranscoderClass;
typedef struct _RygelAudioTranscoderPrivate RygelAudioTranscoderPrivate;

#define RYGEL_TYPE_VIDEO_TRANSCODER (rygel_video_transcoder_get_type ())
#define RYGEL_VIDEO_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_TRANSCODER, RygelVideoTranscoder))
#define RYGEL_VIDEO_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_TRANSCODER, RygelVideoTranscoderClass))
#define RYGEL_IS_VIDEO_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_TRANSCODER))
#define RYGEL_IS_VIDEO_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_TRANSCODER))
#define RYGEL_VIDEO_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_TRANSCODER, RygelVideoTranscoderClass))

typedef struct _RygelVideoTranscoder RygelVideoTranscoder;
typedef struct _RygelVideoTranscoderClass RygelVideoTranscoderClass;
typedef struct _RygelVideoTranscoderPrivate RygelVideoTranscoderPrivate;

#define RYGEL_TYPE_MP2_TS_TRANSCODER (rygel_mp2_ts_transcoder_get_type ())
#define RYGEL_MP2_TS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MP2_TS_TRANSCODER, RygelMP2TSTranscoder))
#define RYGEL_MP2_TS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MP2_TS_TRANSCODER, RygelMP2TSTranscoderClass))
#define RYGEL_IS_MP2_TS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MP2_TS_TRANSCODER))
#define RYGEL_IS_MP2_TS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MP2_TS_TRANSCODER))
#define RYGEL_MP2_TS_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MP2_TS_TRANSCODER, RygelMP2TSTranscoderClass))

typedef struct _RygelMP2TSTranscoder RygelMP2TSTranscoder;
typedef struct _RygelMP2TSTranscoderClass RygelMP2TSTranscoderClass;
typedef struct _RygelMP2TSTranscoderPrivate RygelMP2TSTranscoderPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

typedef enum  {
	RYGEL_MP2_TS_PROFILE_SD_EU = 0,
	RYGEL_MP2_TS_PROFILE_SD_NA,
	RYGEL_MP2_TS_PROFILE_HD_NA
} RygelMP2TSProfile;

struct _RygelGstTranscoder {
	RygelTranscoder parent_instance;
	RygelGstTranscoderPrivate * priv;
};

struct _RygelGstTranscoderClass {
	RygelTranscoderClass parent_class;
	GstEncodingProfile* (*get_encoding_profile) (RygelGstTranscoder* self);
};

struct _RygelAudioTranscoder {
	RygelGstTranscoder parent_instance;
	RygelAudioTranscoderPrivate * priv;
	gint audio_bitrate;
	GstCaps* container_format;
	GstCaps* audio_codec_format;
};

struct _RygelAudioTranscoderClass {
	RygelGstTranscoderClass parent_class;
};

struct _RygelVideoTranscoder {
	RygelAudioTranscoder parent_instance;
	RygelVideoTranscoderPrivate * priv;
};

struct _RygelVideoTranscoderClass {
	RygelAudioTranscoderClass parent_class;
};

struct _RygelMP2TSTranscoder {
	RygelVideoTranscoder parent_instance;
	RygelMP2TSTranscoderPrivate * priv;
};

struct _RygelMP2TSTranscoderClass {
	RygelVideoTranscoderClass parent_class;
};

struct _RygelMP2TSTranscoderPrivate {
	RygelMP2TSProfile profile;
};


static gpointer rygel_mp2_ts_transcoder_parent_class = NULL;

GType rygel_mp2_ts_profile_get_type (void) G_GNUC_CONST;
GType rygel_gst_transcoder_get_type (void) G_GNUC_CONST;
GType rygel_audio_transcoder_get_type (void) G_GNUC_CONST;
GType rygel_video_transcoder_get_type (void) G_GNUC_CONST;
GType rygel_mp2_ts_transcoder_get_type (void) G_GNUC_CONST;
#define RYGEL_MP2_TS_TRANSCODER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MP2_TS_TRANSCODER, RygelMP2TSTranscoderPrivate))
enum  {
	RYGEL_MP2_TS_TRANSCODER_DUMMY_PROPERTY
};
#define RYGEL_MP2_TS_TRANSCODER_VIDEO_BITRATE 1500
#define RYGEL_MP2_TS_TRANSCODER_AUDIO_BITRATE 192
#define RYGEL_MP2_TS_TRANSCODER_CONTAINER "video/mpegts,systemstream=true,packetsize=188"
#define RYGEL_MP2_TS_TRANSCODER_AUDIO_FORMAT "audio/mpeg,mpegversion=1,layer=2"
#define RYGEL_MP2_TS_TRANSCODER_BASE_VIDEO_FORMAT "video/mpeg,mpegversion=2,systemstream=false"
#define RYGEL_MP2_TS_TRANSCODER_RESTRICTION_TEMPLATE "video/x-raw,framerate=(fraction)%d/1,width=%d,height=%d"
RygelMP2TSTranscoder* rygel_mp2_ts_transcoder_new (RygelMP2TSProfile profile);
RygelMP2TSTranscoder* rygel_mp2_ts_transcoder_construct (GType object_type, RygelMP2TSProfile profile);
RygelVideoTranscoder* rygel_video_transcoder_new (const gchar* content_type, const gchar* dlna_profile, gint audio_bitrate, gint video_bitrate, const gchar* container_caps, const gchar* audio_codec_caps, const gchar* video_codec_caps, const gchar* extension, const gchar* restrictions);
RygelVideoTranscoder* rygel_video_transcoder_construct (GType object_type, const gchar* content_type, const gchar* dlna_profile, gint audio_bitrate, gint video_bitrate, const gchar* container_caps, const gchar* audio_codec_caps, const gchar* video_codec_caps, const gchar* extension, const gchar* restrictions);
static GUPnPDIDLLiteResource* rygel_mp2_ts_transcoder_real_add_resource (RygelTranscoder* base, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
static guint rygel_mp2_ts_transcoder_real_get_distance (RygelTranscoder* base, RygelMediaItem* item);
static void rygel_mp2_ts_transcoder_finalize (GObject* obj);

static const gint RYGEL_MP2_TS_TRANSCODER_WIDTH[3] = {720, 720, 1280};
static const gint RYGEL_MP2_TS_TRANSCODER_HEIGHT[3] = {576, 480, 720};
static const gint RYGEL_MP2_TS_TRANSCODER_FRAME_RATE[3] = {25, 30, 30};
static const gchar* RYGEL_MP2_TS_TRANSCODER_PROFILES[3] = {"MPEG_TS_SD_EU_ISO", "MPEG_TS_SD_NA_ISO", "MPEG_TS_HD_NA_ISO"};

GType rygel_mp2_ts_profile_get_type (void) {
	static volatile gsize rygel_mp2_ts_profile_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_mp2_ts_profile_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_MP2_TS_PROFILE_SD_EU, "RYGEL_MP2_TS_PROFILE_SD_EU", "sd-eu"}, {RYGEL_MP2_TS_PROFILE_SD_NA, "RYGEL_MP2_TS_PROFILE_SD_NA", "sd-na"}, {RYGEL_MP2_TS_PROFILE_HD_NA, "RYGEL_MP2_TS_PROFILE_HD_NA", "hd-na"}, {0, NULL, NULL}};
		GType rygel_mp2_ts_profile_type_id;
		rygel_mp2_ts_profile_type_id = g_enum_register_static ("RygelMP2TSProfile", values);
		g_once_init_leave (&rygel_mp2_ts_profile_type_id__volatile, rygel_mp2_ts_profile_type_id);
	}
	return rygel_mp2_ts_profile_type_id__volatile;
}


RygelMP2TSTranscoder* rygel_mp2_ts_transcoder_construct (GType object_type, RygelMP2TSProfile profile) {
	RygelMP2TSTranscoder * self = NULL;
	RygelMP2TSProfile _tmp0_;
	const gchar* _tmp1_;
	RygelMP2TSProfile _tmp2_;
	gint _tmp3_;
	RygelMP2TSProfile _tmp4_;
	gint _tmp5_;
	RygelMP2TSProfile _tmp6_;
	gint _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	RygelMP2TSProfile _tmp10_;
	_tmp0_ = profile;
	_tmp1_ = RYGEL_MP2_TS_TRANSCODER_PROFILES[_tmp0_];
	_tmp2_ = profile;
	_tmp3_ = RYGEL_MP2_TS_TRANSCODER_FRAME_RATE[_tmp2_];
	_tmp4_ = profile;
	_tmp5_ = RYGEL_MP2_TS_TRANSCODER_WIDTH[_tmp4_];
	_tmp6_ = profile;
	_tmp7_ = RYGEL_MP2_TS_TRANSCODER_HEIGHT[_tmp6_];
	_tmp8_ = g_strdup_printf (RYGEL_MP2_TS_TRANSCODER_RESTRICTION_TEMPLATE, _tmp3_, _tmp5_, _tmp7_);
	_tmp9_ = _tmp8_;
	self = (RygelMP2TSTranscoder*) rygel_video_transcoder_construct (object_type, "video/mpeg", _tmp1_, RYGEL_MP2_TS_TRANSCODER_AUDIO_BITRATE, RYGEL_MP2_TS_TRANSCODER_VIDEO_BITRATE, RYGEL_MP2_TS_TRANSCODER_CONTAINER, RYGEL_MP2_TS_TRANSCODER_AUDIO_FORMAT, RYGEL_MP2_TS_TRANSCODER_BASE_VIDEO_FORMAT, "mpg", _tmp9_);
	_g_free0 (_tmp9_);
	_tmp10_ = profile;
	self->priv->profile = _tmp10_;
	return self;
}


RygelMP2TSTranscoder* rygel_mp2_ts_transcoder_new (RygelMP2TSProfile profile) {
	return rygel_mp2_ts_transcoder_construct (RYGEL_TYPE_MP2_TS_TRANSCODER, profile);
}


static GUPnPDIDLLiteResource* rygel_mp2_ts_transcoder_real_add_resource (RygelTranscoder* base, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error) {
	RygelMP2TSTranscoder * self;
	GUPnPDIDLLiteResource* result = NULL;
	GUPnPDIDLLiteItem* _tmp0_;
	RygelMediaItem* _tmp1_;
	RygelTranscodeManager* _tmp2_;
	GUPnPDIDLLiteResource* _tmp3_ = NULL;
	GUPnPDIDLLiteResource* resource;
	RygelMP2TSProfile _tmp4_;
	gint _tmp5_;
	RygelMP2TSProfile _tmp6_;
	gint _tmp7_;
	GError * _inner_error_ = NULL;
	self = (RygelMP2TSTranscoder*) base;
	g_return_val_if_fail (didl_item != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	g_return_val_if_fail (manager != NULL, NULL);
	_tmp0_ = didl_item;
	_tmp1_ = item;
	_tmp2_ = manager;
	_tmp3_ = RYGEL_TRANSCODER_CLASS (rygel_mp2_ts_transcoder_parent_class)->add_resource ((RygelTranscoder*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_VIDEO_TRANSCODER, RygelVideoTranscoder), _tmp0_, _tmp1_, _tmp2_, &_inner_error_);
	resource = _tmp3_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	if (resource == NULL) {
		result = NULL;
		_g_object_unref0 (resource);
		return result;
	}
	_tmp4_ = self->priv->profile;
	_tmp5_ = RYGEL_MP2_TS_TRANSCODER_WIDTH[_tmp4_];
	gupnp_didl_lite_resource_set_width (resource, _tmp5_);
	_tmp6_ = self->priv->profile;
	_tmp7_ = RYGEL_MP2_TS_TRANSCODER_HEIGHT[_tmp6_];
	gupnp_didl_lite_resource_set_height (resource, _tmp7_);
	gupnp_didl_lite_resource_set_bitrate (resource, ((RYGEL_MP2_TS_TRANSCODER_VIDEO_BITRATE + RYGEL_MP2_TS_TRANSCODER_AUDIO_BITRATE) * 1000) / 8);
	result = resource;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static guint rygel_mp2_ts_transcoder_real_get_distance (RygelTranscoder* base, RygelMediaItem* item) {
	RygelMP2TSTranscoder * self;
	guint result = 0U;
	RygelMediaItem* _tmp0_;
	RygelMediaItem* _tmp2_;
	RygelVideoItem* _tmp3_;
	RygelVideoItem* video_item;
	RygelMediaItem* _tmp4_;
	guint _tmp5_ = 0U;
	guint distance;
	RygelVideoItem* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	RygelVideoItem* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	RygelVideoItem* _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	self = (RygelMP2TSTranscoder*) base;
	g_return_val_if_fail (item != NULL, 0U);
	_tmp0_ = item;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_VIDEO_ITEM)) {
		guint _tmp1_;
		_tmp1_ = G_MAXUINT;
		result = _tmp1_;
		return result;
	}
	_tmp2_ = item;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, RYGEL_TYPE_VIDEO_ITEM) ? ((RygelVideoItem*) _tmp2_) : NULL);
	video_item = _tmp3_;
	_tmp4_ = item;
	_tmp5_ = RYGEL_TRANSCODER_CLASS (rygel_mp2_ts_transcoder_parent_class)->get_distance ((RygelTranscoder*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_VIDEO_TRANSCODER, RygelVideoTranscoder), _tmp4_);
	distance = _tmp5_;
	_tmp6_ = video_item;
	_tmp7_ = rygel_audio_item_get_bitrate ((RygelAudioItem*) _tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ > 0) {
		guint _tmp9_;
		RygelVideoItem* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _tmp13_ = 0;
		_tmp9_ = distance;
		_tmp10_ = video_item;
		_tmp11_ = rygel_audio_item_get_bitrate ((RygelAudioItem*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = abs (_tmp12_ - RYGEL_MP2_TS_TRANSCODER_VIDEO_BITRATE);
		distance = _tmp9_ + _tmp13_;
	}
	_tmp14_ = video_item;
	_tmp15_ = rygel_visual_item_get_width ((RygelVisualItem*) _tmp14_);
	_tmp16_ = _tmp15_;
	if (_tmp16_ > 0) {
		guint _tmp17_;
		RygelVideoItem* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		RygelMP2TSProfile _tmp21_;
		gint _tmp22_;
		gint _tmp23_ = 0;
		_tmp17_ = distance;
		_tmp18_ = video_item;
		_tmp19_ = rygel_visual_item_get_width ((RygelVisualItem*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = self->priv->profile;
		_tmp22_ = RYGEL_MP2_TS_TRANSCODER_WIDTH[_tmp21_];
		_tmp23_ = abs (_tmp20_ - _tmp22_);
		distance = _tmp17_ + _tmp23_;
	}
	_tmp24_ = video_item;
	_tmp25_ = rygel_visual_item_get_height ((RygelVisualItem*) _tmp24_);
	_tmp26_ = _tmp25_;
	if (_tmp26_ > 0) {
		guint _tmp27_;
		RygelVideoItem* _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
		RygelMP2TSProfile _tmp31_;
		gint _tmp32_;
		gint _tmp33_ = 0;
		_tmp27_ = distance;
		_tmp28_ = video_item;
		_tmp29_ = rygel_visual_item_get_height ((RygelVisualItem*) _tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = self->priv->profile;
		_tmp32_ = RYGEL_MP2_TS_TRANSCODER_HEIGHT[_tmp31_];
		_tmp33_ = abs (_tmp30_ - _tmp32_);
		distance = _tmp27_ + _tmp33_;
	}
	result = distance;
	_g_object_unref0 (video_item);
	return result;
}


static void rygel_mp2_ts_transcoder_class_init (RygelMP2TSTranscoderClass * klass) {
	rygel_mp2_ts_transcoder_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMP2TSTranscoderPrivate));
	RYGEL_TRANSCODER_CLASS (klass)->add_resource = rygel_mp2_ts_transcoder_real_add_resource;
	RYGEL_TRANSCODER_CLASS (klass)->get_distance = rygel_mp2_ts_transcoder_real_get_distance;
	G_OBJECT_CLASS (klass)->finalize = rygel_mp2_ts_transcoder_finalize;
}


static void rygel_mp2_ts_transcoder_instance_init (RygelMP2TSTranscoder * self) {
	self->priv = RYGEL_MP2_TS_TRANSCODER_GET_PRIVATE (self);
}


static void rygel_mp2_ts_transcoder_finalize (GObject* obj) {
	RygelMP2TSTranscoder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MP2_TS_TRANSCODER, RygelMP2TSTranscoder);
	G_OBJECT_CLASS (rygel_mp2_ts_transcoder_parent_class)->finalize (obj);
}


/**
 * Transcoder for mpeg transport stream containing mpeg 2 video and mp2 audio.
 */
GType rygel_mp2_ts_transcoder_get_type (void) {
	static volatile gsize rygel_mp2_ts_transcoder_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_mp2_ts_transcoder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMP2TSTranscoderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_mp2_ts_transcoder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMP2TSTranscoder), 0, (GInstanceInitFunc) rygel_mp2_ts_transcoder_instance_init, NULL };
		GType rygel_mp2_ts_transcoder_type_id;
		rygel_mp2_ts_transcoder_type_id = g_type_register_static (RYGEL_TYPE_VIDEO_TRANSCODER, "RygelMP2TSTranscoder", &g_define_type_info, 0);
		g_once_init_leave (&rygel_mp2_ts_transcoder_type_id__volatile, rygel_mp2_ts_transcoder_type_id);
	}
	return rygel_mp2_ts_transcoder_type_id__volatile;
}



