extern crate locale;

#[cfg(target_os = "linux")]
pub fn main() {
    use locale::linux::LibCLocaleFactory;
    use locale::linux::langinfo;
    use std::fmt::Debug;

    fn show<'a, T: langinfo::LanginfoItem<'a> + Debug>(f: &'a LibCLocaleFactory, i: T) {
        let j = f.langinfo(i);
        println!("{:?} = {:?}", i, j);
    }

    let f = LibCLocaleFactory::new("").unwrap();

    show(&f, langinfo::_NL_COLLATE_CODESET);
    show(&f, langinfo::_NL_CTYPE_CODESET_NAME);
    show(&f, langinfo::_NL_MONETARY_CODESET);
    show(&f, langinfo::_NL_NUMERIC_CODESET);
    show(&f, langinfo::_NL_TIME_CODESET);
    show(&f, langinfo::_NL_MESSAGES_CODESET);
    show(&f, langinfo::_NL_PAPER_CODESET);
    show(&f, langinfo::_NL_NAME_CODESET);
    show(&f, langinfo::_NL_ADDRESS_CODESET);
    show(&f, langinfo::_NL_TELEPHONE_CODESET);
    show(&f, langinfo::_NL_MEASUREMENT_CODESET);
    show(&f, langinfo::_NL_IDENTIFICATION_CODESET);
    show(&f, langinfo::_NL_COLLATE_RULESETS);
    show(&f, langinfo::_NL_CTYPE_INDIGITS0_MB);
    show(&f, langinfo::_NL_CTYPE_INDIGITS1_MB);
    show(&f, langinfo::_NL_CTYPE_INDIGITS2_MB);
    show(&f, langinfo::_NL_CTYPE_INDIGITS3_MB);
    show(&f, langinfo::_NL_CTYPE_INDIGITS4_MB);
    show(&f, langinfo::_NL_CTYPE_INDIGITS5_MB);
    show(&f, langinfo::_NL_CTYPE_INDIGITS6_MB);
    show(&f, langinfo::_NL_CTYPE_INDIGITS7_MB);
    show(&f, langinfo::_NL_CTYPE_INDIGITS8_MB);
    show(&f, langinfo::_NL_CTYPE_INDIGITS9_MB);
    show(&f, langinfo::_NL_CTYPE_OUTDIGIT0_MB);
    show(&f, langinfo::_NL_CTYPE_OUTDIGIT1_MB);
    show(&f, langinfo::_NL_CTYPE_OUTDIGIT2_MB);
    show(&f, langinfo::_NL_CTYPE_OUTDIGIT3_MB);
    show(&f, langinfo::_NL_CTYPE_OUTDIGIT4_MB);
    show(&f, langinfo::_NL_CTYPE_OUTDIGIT5_MB);
    show(&f, langinfo::_NL_CTYPE_OUTDIGIT6_MB);
    show(&f, langinfo::_NL_CTYPE_OUTDIGIT7_MB);
    show(&f, langinfo::_NL_CTYPE_OUTDIGIT8_MB);
    show(&f, langinfo::_NL_CTYPE_OUTDIGIT9_MB);
    show(&f, langinfo::_NL_CTYPE_TRANSLIT_IGNORE);
    show(&f, langinfo::_NL_CTYPE_CLASS_NAMES);
    show(&f, langinfo::_NL_CTYPE_MAP_NAMES);
    show(&f, langinfo::INT_CURR_SYMBOL);
    show(&f, langinfo::CURRENCY_SYMBOL);
    show(&f, langinfo::MON_DECIMAL_POINT);
    show(&f, langinfo::MON_THOUSANDS_SEP);
    show(&f, langinfo::POSITIVE_SIGN);
    show(&f, langinfo::NEGATIVE_SIGN);
    show(&f, langinfo::_NL_MONETARY_CRNCYSTR);
    show(&f, langinfo::_NL_MONETARY_DUO_INT_CURR_SYMBOL);
    show(&f, langinfo::_NL_MONETARY_DUO_CURRENCY_SYMBOL);
    show(&f, langinfo::__DECIMAL_POINT);
    show(&f, langinfo::__THOUSANDS_SEP);
    show(&f, langinfo::ABDAY_1);
    show(&f, langinfo::ABDAY_2);
    show(&f, langinfo::ABDAY_3);
    show(&f, langinfo::ABDAY_4);
    show(&f, langinfo::ABDAY_5);
    show(&f, langinfo::ABDAY_6);
    show(&f, langinfo::ABDAY_7);
    show(&f, langinfo::DAY_1);
    show(&f, langinfo::DAY_2);
    show(&f, langinfo::DAY_3);
    show(&f, langinfo::DAY_4);
    show(&f, langinfo::DAY_5);
    show(&f, langinfo::DAY_6);
    show(&f, langinfo::DAY_7);
    show(&f, langinfo::ABMON_1);
    show(&f, langinfo::ABMON_2);
    show(&f, langinfo::ABMON_3);
    show(&f, langinfo::ABMON_4);
    show(&f, langinfo::ABMON_5);
    show(&f, langinfo::ABMON_6);
    show(&f, langinfo::ABMON_7);
    show(&f, langinfo::ABMON_8);
    show(&f, langinfo::ABMON_9);
    show(&f, langinfo::ABMON_10);
    show(&f, langinfo::ABMON_11);
    show(&f, langinfo::ABMON_12);
    show(&f, langinfo::MON_1);
    show(&f, langinfo::MON_2);
    show(&f, langinfo::MON_3);
    show(&f, langinfo::MON_4);
    show(&f, langinfo::MON_5);
    show(&f, langinfo::MON_6);
    show(&f, langinfo::MON_7);
    show(&f, langinfo::MON_8);
    show(&f, langinfo::MON_9);
    show(&f, langinfo::MON_10);
    show(&f, langinfo::MON_11);
    show(&f, langinfo::MON_12);
    show(&f, langinfo::AM_STR);
    show(&f, langinfo::PM_STR);
    show(&f, langinfo::D_T_FMT);
    show(&f, langinfo::D_FMT);
    show(&f, langinfo::T_FMT);
    show(&f, langinfo::T_FMT_AMPM);
    show(&f, langinfo::ERA_YEAR);
    show(&f, langinfo::ERA_D_FMT);
    show(&f, langinfo::ERA_D_T_FMT);
    show(&f, langinfo::ERA_T_FMT);
    show(&f, langinfo::_NL_TIME_ERA_ENTRIES);
    show(&f, langinfo::_NL_TIME_TIMEZONE);
    show(&f, langinfo::_DATE_FMT);
    show(&f, langinfo::ERA);
    show(&f, langinfo::ALT_DIGITS);
    show(&f, langinfo::YESEXPR);
    show(&f, langinfo::NOEXPR);
    show(&f, langinfo::YESSTR);
    show(&f, langinfo::NOSTR);
    show(&f, langinfo::_NL_NAME_NAME_FMT);
    show(&f, langinfo::_NL_NAME_NAME_GEN);
    show(&f, langinfo::_NL_NAME_NAME_MR);
    show(&f, langinfo::_NL_NAME_NAME_MRS);
    show(&f, langinfo::_NL_NAME_NAME_MISS);
    show(&f, langinfo::_NL_NAME_NAME_MS);
    show(&f, langinfo::_NL_ADDRESS_POSTAL_FMT);
    show(&f, langinfo::_NL_ADDRESS_COUNTRY_NAME);
    show(&f, langinfo::_NL_ADDRESS_COUNTRY_POST);
    show(&f, langinfo::_NL_ADDRESS_COUNTRY_AB2);
    show(&f, langinfo::_NL_ADDRESS_COUNTRY_AB3);
    show(&f, langinfo::_NL_ADDRESS_COUNTRY_CAR);
    show(&f, langinfo::_NL_ADDRESS_COUNTRY_ISBN);
    show(&f, langinfo::_NL_ADDRESS_LANG_NAME);
    show(&f, langinfo::_NL_ADDRESS_LANG_AB);
    show(&f, langinfo::_NL_ADDRESS_LANG_TERM);
    show(&f, langinfo::_NL_ADDRESS_LANG_LIB);
    show(&f, langinfo::_NL_TELEPHONE_TEL_INT_FMT);
    show(&f, langinfo::_NL_TELEPHONE_TEL_DOM_FMT);
    show(&f, langinfo::_NL_TELEPHONE_INT_SELECT);
    show(&f, langinfo::_NL_TELEPHONE_INT_PREFIX);
    show(&f, langinfo::__INT_FRAC_DIGITS);
    show(&f, langinfo::__FRAC_DIGITS);
    show(&f, langinfo::__P_CS_PRECEDES);
    show(&f, langinfo::__P_SEP_BY_SPACE);
    show(&f, langinfo::__N_CS_PRECEDES);
    show(&f, langinfo::__N_SEP_BY_SPACE);
    show(&f, langinfo::__P_SIGN_POSN);
    show(&f, langinfo::__N_SIGN_POSN);
    show(&f, langinfo::__INT_P_CS_PRECEDES);
    show(&f, langinfo::__INT_P_SEP_BY_SPACE);
    show(&f, langinfo::__INT_N_CS_PRECEDES);
    show(&f, langinfo::__INT_N_SEP_BY_SPACE);
    show(&f, langinfo::__INT_P_SIGN_POSN);
    show(&f, langinfo::__INT_N_SIGN_POSN);
    show(&f, langinfo::_NL_MONETARY_DUO_INT_FRAC_DIGITS);
    show(&f, langinfo::_NL_MONETARY_DUO_FRAC_DIGITS);
    show(&f, langinfo::_NL_MONETARY_DUO_P_CS_PRECEDES);
    show(&f, langinfo::_NL_MONETARY_DUO_P_SEP_BY_SPACE);
    show(&f, langinfo::_NL_MONETARY_DUO_N_CS_PRECEDES);
    show(&f, langinfo::_NL_MONETARY_DUO_N_SEP_BY_SPACE);
    show(&f, langinfo::_NL_MONETARY_DUO_INT_P_CS_PRECEDES);
    show(&f, langinfo::_NL_MONETARY_DUO_INT_P_SEP_BY_SPACE);
    show(&f, langinfo::_NL_MONETARY_DUO_INT_N_CS_PRECEDES);
    show(&f, langinfo::_NL_MONETARY_DUO_INT_N_SEP_BY_SPACE);
    show(&f, langinfo::_NL_MONETARY_DUO_P_SIGN_POSN);
    show(&f, langinfo::_NL_MONETARY_DUO_N_SIGN_POSN);
    show(&f, langinfo::_NL_MONETARY_DUO_INT_P_SIGN_POSN);
    show(&f, langinfo::_NL_MONETARY_DUO_INT_N_SIGN_POSN);
    show(&f, langinfo::_NL_TIME_WEEK_NDAYS);
    show(&f, langinfo::_NL_TIME_WEEK_1STWEEK);
    show(&f, langinfo::_NL_TIME_FIRST_WEEKDAY);
    show(&f, langinfo::_NL_TIME_FIRST_WORKDAY);
    show(&f, langinfo::_NL_TIME_CAL_DIRECTION);
    show(&f, langinfo::_NL_MEASUREMENT_MEASUREMENT);
    show(&f, langinfo::_NL_CTYPE_WIDTH);
    show(&f, langinfo::__MON_GROUPING);
    show(&f, langinfo::__GROUPING);
    show(&f, langinfo::_NL_COLLATE_NRULES);
    show(&f, langinfo::_NL_COLLATE_SYMB_HASH_SIZEMB);
    show(&f, langinfo::_NL_CTYPE_MB_CUR_MAX);
    show(&f, langinfo::_NL_CTYPE_CLASS_OFFSET);
    show(&f, langinfo::_NL_CTYPE_MAP_OFFSET);
    show(&f, langinfo::_NL_CTYPE_INDIGITS_MB_LEN);
    show(&f, langinfo::_NL_CTYPE_INDIGITS_WC_LEN);
    show(&f, langinfo::_NL_CTYPE_TRANSLIT_TAB_SIZE);
    show(&f, langinfo::_NL_CTYPE_TRANSLIT_DEFAULT_MISSING_LEN);
    show(&f, langinfo::_NL_CTYPE_TRANSLIT_IGNORE_LEN);
    show(&f, langinfo::_NL_CTYPE_MAP_TO_NONASCII);
    show(&f, langinfo::_NL_CTYPE_NONASCII_CASE);
    show(&f, langinfo::_NL_MONETARY_UNO_VALID_FROM);
    show(&f, langinfo::_NL_MONETARY_UNO_VALID_TO);
    show(&f, langinfo::_NL_MONETARY_DUO_VALID_FROM);
    show(&f, langinfo::_NL_MONETARY_DUO_VALID_TO);
    show(&f, langinfo::_NL_TIME_ERA_NUM_ENTRIES);
    show(&f, langinfo::_NL_TIME_WEEK_1STDAY);
    show(&f, langinfo::_NL_PAPER_HEIGHT);
    show(&f, langinfo::_NL_PAPER_WIDTH);
    show(&f, langinfo::_NL_ADDRESS_COUNTRY_NUM);
    show(&f, langinfo::_NL_CTYPE_OUTDIGIT0_WC);
    show(&f, langinfo::_NL_CTYPE_OUTDIGIT1_WC);
    show(&f, langinfo::_NL_CTYPE_OUTDIGIT2_WC);
    show(&f, langinfo::_NL_CTYPE_OUTDIGIT3_WC);
    show(&f, langinfo::_NL_CTYPE_OUTDIGIT4_WC);
    show(&f, langinfo::_NL_CTYPE_OUTDIGIT5_WC);
    show(&f, langinfo::_NL_CTYPE_OUTDIGIT6_WC);
    show(&f, langinfo::_NL_CTYPE_OUTDIGIT7_WC);
    show(&f, langinfo::_NL_CTYPE_OUTDIGIT8_WC);
    show(&f, langinfo::_NL_CTYPE_OUTDIGIT9_WC);
    show(&f, langinfo::_NL_MONETARY_DECIMAL_POINT_WC);
    show(&f, langinfo::_NL_MONETARY_THOUSANDS_SEP_WC);
    show(&f, langinfo::_NL_NUMERIC_DECIMAL_POINT_WC);
    show(&f, langinfo::_NL_NUMERIC_THOUSANDS_SEP_WC);
    show(&f, langinfo::_NL_IDENTIFICATION_TITLE);
    show(&f, langinfo::_NL_IDENTIFICATION_SOURCE);
    show(&f, langinfo::_NL_IDENTIFICATION_ADDRESS);
    show(&f, langinfo::_NL_IDENTIFICATION_CONTACT);
    show(&f, langinfo::_NL_IDENTIFICATION_EMAIL);
    show(&f, langinfo::_NL_IDENTIFICATION_TEL);
    show(&f, langinfo::_NL_IDENTIFICATION_FAX);
    show(&f, langinfo::_NL_IDENTIFICATION_LANGUAGE);
    show(&f, langinfo::_NL_IDENTIFICATION_TERRITORY);
    show(&f, langinfo::_NL_IDENTIFICATION_AUDIENCE);
    show(&f, langinfo::_NL_IDENTIFICATION_APPLICATION);
    show(&f, langinfo::_NL_IDENTIFICATION_ABBREVIATION);
    show(&f, langinfo::_NL_IDENTIFICATION_REVISION);
    show(&f, langinfo::_NL_IDENTIFICATION_DATE);
    show(&f, langinfo::_NL_IDENTIFICATION_CATEGORY);
}

#[cfg(not(target_os = "linux"))]
pub fn main() {
    println!("Listing locale info not (yet) supported on this system");
}
