<template name="header">
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<html>
<head>
<title>{title}</title>
<meta name="GENERATOR" content="{generator_name} {generator_version}">
</head>
<body bgcolor="#ffffff" text="#000000">
</template>

<template name="header_title_repository">
Welcome to the RPM repository on {host}
</template>

<template name="header_title_install">
Welcome to the RPM description of {host}
</template>

<template name="footer">
<hr>
<p>Generated by <a href="{generator_url}">{generator_name} {generator_version}</a>
<p><a href="mailto:{maintainer_mail}">{maintainer_name}</a>, {time}
</body>
</html>
</template>

<template name="rpm_row">
<tr bgcolor="{bgcolor}"><td width="250"><a href="{uri}">{name}</a>{new}</td>
<td width="450">{summary}</td>
<td>{system}</td></tr>
</template>

<template name="new_item">
<img src="{url}/new.png" alt="New">
</template>

<template name="arch_row">
<tr><td width="250">{name}</td>
<td width="450">{summary}</td>
</template>

<template name="arch_row_item_dir">
<td bgcolor="{bgcolor}" width="95"><a href="{uri}">{os}/{arch}</a>{new}</td>
</template>

<template name="arch_row_item">
<td width="95"><a href="{uri}">{os}/{arch}</a>{new}</td>
</template>

<template name="arch_row_end">
</tr>
</template>

<!-- note: XXX maybe HTML file names should be parametrized to prevent their corruption or to allow "transparent transition" in case we change those names in the program which will create mismatch with template as it is now -->
<template name="main_header">
<table border=5 cellspacing=5 cellpadding=5>
<tbody>
<tr>
<td><a href="{url}/index.html">Index</a></td>
<td><a href="{url}/Groups.html">index by Group</a></td>
<td><a href="{url}/Distribs.html">index by Distribution</a></td>
<td><a href="{url}/Vendors.html">index by Vendor</a></td>
<td><a href="{url}/ByDate.html">index by date</a></td> <!-- XXX here we made "a step back" while we wont distinguish between "index by creation date" for repositories and "index by installation date" for "installed report" -->
<td><a href="{url}/ByName.html">index by Name</a></td>
</template>

<template name="main_item">
<td><a href="{url}">{name}</a></td>
</template>

<template name="main_footer">
</tr>
</tbody></table>
</template>

<template name="color_indicator_header">
<table align="center"><tbody>
<tr>
</template>

<template name="color_indicator_item">
<td bgcolor="{color}">{item}</td>
</template>

<template name="color_indicator_eol">
</tr><tr>
</template>

<template name="color_indicator_footer">
</tr>
</tbody></table>
</template>

<template name="html_tree_color">
<blockquote{color}>
</template>

<template name="html_tree_header">
<p><strong><a href="{url}/index.html"><img src="{url}/dir.png" alt="parent-directory" border=0> ..</a></strong></p>
</template>

<template name="html_tree_sublevel_header">
<h3>Sub Directories</h3>
</template>

<template name="html_tree_header_color">
 style="background : {color}"
</template>

<template name="html_tree_item">
<p><strong><a href="{url}/{suburi}/index.html"><img src="{url}/dir.png" alt="sub-directory" border=0>{name}</a></strong></p>
</template>

<template name="html_tree_footer">
</blockquote>
</template>

<template name="parent_names">
<a href="{url}/index.html">{name}</a>
{separator}
</template>

<template name="parent_names_separator">
 / 
</template>

<template name="index_header">
<h1 align=center>{title}</h1>
<p>
<strong>rpm2html</strong> automatically generates Web pages describing a set of
<a href="http://www.rpm.org/">RPM</a> packages.</p>
<p>
<a href="http://rpmfind.net/linux/rpm2html/rpmfind.html">
The Rpmfind tool</a> allows automate the search of packages from
the RPM Database or maintain your system up-to-date in a more automated way.
<p>
The goals of rpm2html are also to identify the dependencies between
various packages and to find the package(s) providing the resources
needed to install a given package. Every package is analyzed to
retrieve its dependencies and the resources it offers. These
relationships are expressed using hyperlinks in the generated
pages. Finding the package providing the resource you need is just a
matter of a few clicks!</p>
<p>Check the <a href="http://rpmfind.net/linux/rpm2html/faq.html">FAQ</a>
in case of problems with rpm2html or rpmfind.
<p>
The proper working of the rpm2html tools requires the package maintainer
to properly comment their RPM(s), if you maintain packages, make sure
that the information are provided adequately (URL, email, ...).</p>
<p>Learn how to <a href="http://rpmfind.net/linux/rpm2html/mirror.html">
build your own mirror</a> of this site. <B><FONT COLOR="#FF0000">
<FONT SIZE="+2">Do not try to mirror it with a Web copy tool</FONT>
</FONT></B></p>
<form action="http://{search_host}/linux/rpm2html/search.php?query=" enctype="application/x-www-form-urlencoded" method="GET">
<input name="query" type="TEXT" size="40" value="">
    <input name=submit type=submit value="Search ...">
    </form>
<h3>{stats}</h3>
<ul>
<li>
The list of  <a href="Groups.html">RPM indexed by category</a>
<li>
The list of  <a href="ByDate.html">RPM indexed by date of creation</a>
<li>
The list of  <a href="ByName.html">RPM indexed by name</a>
<li>
The list of  <a href="Vendors.html">RPM indexed by maintainer</a>
<li>
The list of  <a href="Distribs.html">RPM indexed by distribution</a>
</ul>
</template>

<template name="index_header_stats_repository">
This archive hosts {count} RPMs representing {size} MBytes of data
</template>

<template name="index_header_stats_installed">
On this machine {count} RPMs are installed representing {size} MBytes of data
</template>

<template name="index_sql_dirlist">
<p><strong><a href="{url}/{suburl}/index.html"><img src="/linux/RPM/dir.png" alt="sub-directory" border=0>{name}</a></strong></p>
</template>

<template name="index_footer">
<p>Generation took {generation_time} seconds</p>
</template>

<template name="rpm_title">
{name} RPM
</template>

<template name="rpm_subtitle">
<h1 align=center><a href="{url}">
{subtitle}</a></h1>
</template>

<template name="rpm_subtitle_src">
{name}-{version}-{release} Source RPM
</template>

<template name="rpm_subtitle_arch">
{name}-{version}-{release} RPM for {arch}
</template>

<template name="rpm_subtitle_arch_unknown">
{name}-{version}-{release} RPM
</template>

<template name="rpm_subsubtitle_begin">
<h3 align=center>From 
</template>

<template name="rpm_subsubtitle_body">
<a href="{url}">{name}</a>
</template>

<template name="rpm_subsubtitle_body_nourl">
{name}
</template>

<template name="rpm_subsubtitle_end">
</h3>
</template>

<template name="rpm_body">
<table align=center border=5 cellspacing=5 cellpadding=5 bgcolor="{color}">
<tbody>
<tr><td>Name: {name}</td>
<td>Distribution: <a href="{url}/{distrib_url}">{distribution}</a></td></tr>
<tr><td>Version: {version}</td>
<td>Vendor: <a href="{url}/{vendor_url}">{vendor}</a></td></tr>
<tr><td>Release: {release}</td>
<td>{date_title}: {date}</td></tr>
<tr><td>Group: <a href="{group_url}">{group}</a></td>
<td>Build host: {build_host}</td></tr>
<tr><td>Size: {size}</td>
<td>Source RPM: {source_rpm}</td></tr>
<tr><td colspan="2">Packager: {packager}</td></tr>
<tr><td colspan="2">Url: <a href="{home_url}">{home_url}</a></td></tr>
<tr><td colspan="2">Summary: {summary}</td></tr>
</tbody>
</table>
<pre>{description}</pre>
</template>

<template name="rpm_body_date_build">
Build date
</template>

<template name="rpm_body_date_install">
Install date
</template>

<template name="rpm_body_src_rpm_name">
{srcrpm_name}
</template>

<template name="rpm_body_src_rpm_name_and_url">
<a href="{srcrpm_url}">{srcrpm_name}</a>
</template>

<template name="rpm_body_packager_with_email">
<a href="mailto:{packager_email}">{packager}</a>
</template>

<template name="rpm_body_packager_without_email">
{packager}
</template>

<template name="rpm_resource_list_problem">
<h2 align=center style="color : #ff0000">Warning: this package does not export valid resources lists</h2>
<h2 align=center><a href="{url}/{suburl}">Try to pick another</a></h2>
</template>

<template name="rpm_provides_header">
<h3>Provides</h3>
<ul>
</template>

<template name="rpm_provides_item">
<li><a href="{url}">{name}</a>
</template>

<template name="rpm_provides_footer">
</ul>
</template>

<template name="rpm_requires_header">
<h3>Requires</h3>
<ul>
</template>

<template name="rpm_requires_item">
<li><a href="{url}">{name}</a>{version}
</template>

<template name="rpm_requires_footer">
</ul>
</template>

<template name="rpm_copyright">
<h3>Copyright</h3>
<pre>{copyright}
</pre>
</template>

<template name="rpm_signatures_header">
<h3>Signatures</h3>
</template>

<template name="rpm_signatures_item">
<pre>{signature}
</pre>
</template>

<template name="rpm_changelog">
<h3>Changelog</h3>
<pre>{changelog}
</pre>
</template>

<template name="rpm_files_header">
<h3>Files</h3>
</template>

<template name="rpm_files_body">
<pre>{files}
</pre>
</template>

<template name="rpm_files_body_no_files">
<bold>No Filelist in the Package !</bold>
</template>

<template name="resource_header">
<h1 align=center>{title}</h1>
<h3>Provided by</h3>
</template>

<template name="resource_title">
RPM resource {name}
</template>

<template name="resource_body_begin">
<table><tbody>
</template>

<template name="resource_body_end">
</tbody></table>
</template>

<template name="groups_header">
<h1 align=center>{title}</h1>
<ul>
</template>

<template name="groups_title">
index by Group
</template>

<template name="groups_item">
<li><a href="{url}">{name} ({count})</a></li>
</template>

<template name="groups_footer">
</ul>
</template>

<template name="group_header">
<h1 align=center>{title}</h1>
</template>

<template name="group_title">
RPM of Group {name}
</template>

<template name="group_begin">
<table><tbody>
</template>

<template name="group_end">
</tbody></table>
</template>

<template name="distribs_header">
<h1 align=center>{title}</h1>
<ul>
</template>

<template name="distribs_title">
index by Distribution
</template>

<template name="distribs_item">
<li><a href="{url}">{name} ({count})</a></li>
</template>

<template name="distribs_footer">
</ul>
</template>

<template name="distrib_header">
<h1 align=center>{title}</h1>
</template>

<template name="distrib_title">
RPM of Distribution {name}
</template>

<template name="distrib_begin">
<table><tbody>
</template>

<template name="distrib_end">
</tbody></table>
</template>

<template name="vendors_header">
<h1 align=center>{title}</h1>
<ul>
</template>

<template name="vendors_title">
index by Vendor
</template>

<template name="vendors_item">
<li><a href="{url}">{name} ({count})</a></li>
</template>

<template name="vendors_footer">
</ul>
</template>

<template name="vendor_header">
<h1 align=center>{title}</h1>
</template>

<template name="vendor_title">
RPM shipped by {name}
</template>

<template name="vendor_begin">
<table><tbody>
</template>

<template name="vendor_end">
</tbody></table>
</template>

<template name="dates_header">
<h1 align=center>{title}</h1>
</template>

<template name="cdates_title">
index by creation date
</template>

<template name="dates_subheader">
<h2>{title}</h2>
</template>

<template name="dates_begin">
<table><tbody>
</template>

<template name="cdates_title_less_3d_old">
RPMs less than three days old
</template>

<template name="cdates_title_less_1w_old">
RPMs less than one week old
</template>

<template name="cdates_title_less_2w_old">
RPMs less than two weeks old
</template>

<template name="cdates_title_less_1m_old">
RPMs less than one month old
</template>

<template name="cdates_title_more_1m_old">
RPMs more than 1 months old
</template>

<template name="dates_end">
</tbody></table>
</template>

<template name="dates_next_page">
<a href="{next_page}ByDate.html">...</a>
</template>

<template name="cdates_item">
<li><a href="{url}">{name} ({count})</a></li>
</template>

<template name="cdate_header">
<h1 align=center>{title}</h1>
<ul>
</template>

<template name="cdate_title">
RPM shipped by {name}
</template>

<template name="cdate_begin">
<table><tbody>
</template>

<template name="cdate_end">
</tbody></table>
</template>

<template name="idates_title">
index by installation date
</template>

<template name="idates_title_less_3d_old">
RPMs installed less than three days ago
</template>

<template name="idates_title_less_1w_old">
RPMs installed less than one week ago
</template>

<template name="idates_title_less_2w_old">
RPMs installed less than two weeks ago
</template>

<template name="idates_title_less_1m_old">
RPMs installed less than one month ago
</template>

<template name="idates_title_more_1m_old">
RPMs installed more than 1 months ago
</template>

<template name="idates_item">
<li><a href="{url}">{name} ({count})</a></li>
</template>

<template name="idate_header">
<h1 align=center>{title}</h1>
<ul>
</template>

<template name="idate_title">
RPM shipped by {name}
</template>

<template name="idate_begin">
<table><tbody>
</template>

<template name="idate_end">
</tbody></table>
</template>

<template name="dates_rdf">
<p>Available as <a href="rdf">an rdf channel</a></p>
</template>

<template name="names_header">
<h1 align=center>{title}</h1>
<table><tbody>
</template>

<template name="names_title">
index by Name
</template>

<template name="names_item">
<p><a href="{letter}ByName.html">{count} Packages beginning with letter {letter}</a></p>
</template>

<template name="name_header">
<h1 align=center>{title}</h1>
</template>

<template name="name_title">
Packages beginning with letter {letter}
</template>

<template name="name_begin">
<table><tbody>
</template>

<template name="name_end">
</tbody></table>
</template>

<template name="dirs_header">
<h1 align=center>{title}</h1>
<ul>
<li>
The list of  <a href="Groups.html">RPM indexed by category</a>
<li>
The list of  <a href="ByDate.html">RPM indexed by date of creation</a>
<li>
The list of  <a href="ByName.html">RPM indexed by name</a>
<li>
The list of  <a href="Vendors.html">RPM indexed by maintainer</a>
<li>
The list of  <a href="Distribs.html">RPM indexed by distribution</a>
</ul>
</template>

<template name="dirs_title">
{dir}
</template>

<template name="dirs_parent">
<a href="RootTree.html">index.html</a>
</template>

<template name="dirs_tree">
<h3>Browse the distribution tree</h3>
<blockquote{color}>
<p><strong><a href="Tree.html"><img src="{url}/dir.png" alt="Directory" border=0> ..</a></strong></p></blockquote>
</template>

<template name="dirs_tree_color">
 style="background : {color}"
</template>

<template name="dirs_item">
<p><a href="{letter}ByName.html">{count} Packages beginning with letter {letter}</a></p>
</template>

<template name="dir_begin">
<table bgcolor="{color}"><tbody>
<tr><td bgcolor="{color}" colspan=2><a href="{url}">{name}</a></td></tr>
</template>

<template name="dir_src">
<tr><td bgcolor="{color}">Repository for sources:</td><td bgcolor="{color}"><a href="{url}">{name}</a></td></tr>
</template>

<template name="dir_mirrors">
<tr><td bgcolor="{color}">Mirrors:</td><td bgcolor="{color}"><a href="{url}">{name}</a></td></tr>
</template>

<template name="dir_mirrors_list_begin">
<tr><td bgcolor="{color}" colspan=2>Mirrors</td></tr>
</template>

<template name="dir_mirrors_list_item">
<tr><td bgcolor="{color}" colspan=2><a href="{url}">{name}</a></td></tr>
</template>

<template name="dir_mirrors_list_end">
</tbody></table>
</template>

<template name="dir_end">
</tbody></table>
</template>

<template name="realtree_title_header">
<h1 align=center><a href="RootTree.html">{name}</a> : <a href="Tree.html">/</a>
</template>

<template name="realtree_title_link">
 <a href="{path}Tree.html">{name}</a>
</template>

<template name="realtree_title_footer">
</h1>
</template>

<template name="realtree_title">
{dir}
</template>

<template name="realtree_item_begin">
<ul>
</template>

<template name="realtree_item_item">
<li> <a href="{url}{suburl}_Tree.html">{name}</a>
</template>

<template name="realtree_item_end">
</ul>
</template>

<template name="realtree_subitem_begin">
<ul>
</template>

<template name="realtree_subitem_dir">
<li><a href="{url}{suburl}_Tree.html"><img src="{rpm2html_url}/dir.png" alt="subdir" border=0> {name}</a>
</template>

<template name="realtree_subitem_file">
<li><a href="{url}">{name}</a>
</template>

<template name="realtree_subitem_end">
</ul>
</template>

<template name="realroot_header">
<h1 align=center>{title}</h1>
</template>

<template name="realroot_title">
{dir}
</template>
