///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2018 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
// demo for the geo class documentation
#define _RHEOLEF_GEO_DEMO_TST_CC
#include "rheolef/geo.h"

#ifdef TO_CLEAN
using namespace rheolef;
using namespace std;
int main(int argc, char**argv) {
  environment rheolef (argc, argv);
  geo omega (argv[1]);
  cout << omega.size() << " " << omega.n_node() << endl;
  for (size_t i = 0, n = omega.size(); i < n; ++i) {
    const geo_element& K = omega[i];
    cout << K.name();
    for (size_t j = 0, m = K.size(); j < m; ++j)
      cout << " " << K[j];
    cout << endl;
  }
  for (size_t jv = 0, nv = omega.n_node(); jv < nv; ++jv)
    cout << omega.node(jv) << endl;
}
#endif // TO_CLEAN
