#!/bin/sh
#
# This file is part of Rheolef.
#
# Copyright (C) 2000-2009 Pierre Saramito 
#
# Rheolef is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Rheolef is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rheolef; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# -------------------------------------------------------------------------
SRCDIR=${SRCDIR-"."}
TOP_SRCDIR=${TOP_SRCDIR-"../.."}
NPROC_MAX=${NPROC_MAX-"3"}
. "${TOP_SRCDIR}/config/loop_mpirun.sh"

status=0

L="
interpolate-line-dom-v2
interpolate-carre-bamg-v2
interpolate-carre-q-10-dom-v2
interpolate-cube-dom-v2
interpolate-cube-H-6-dom-v2
interpolate-carre-tq-10-dom-v2
interpolate-cube-P-5-dom-v2
interpolate-my_cube_TP-5-v2
interpolate-my_cube_PH-5-v2
interpolate-my_cube_TPH-5-v2
interpolate-circle_p3-v2
"
for x in $L; do
  for Pk in P1 P2 P3 P0 P1d; do
    loop_mpirun "./field_io_tst 1e-10 < ${SRCDIR}/$x-$Pk.field 2>/dev/null | diff -w -B ${SRCDIR}/$x-$Pk.field - >/dev/null"
    if test $? -ne 0; then status=1; fi
  done
done
# TODO dom Pk
L="
interpolate_dom-line-dom-v2-right
interpolate_dom-carre-100-dom-v2-right
interpolate_dom-carre-bamg-v2-right
interpolate_dom-cube-10-dom-v2-right
interpolate_dom-cube-gmsh-v2-right
"
for x in $L; do
  for Pk in P0 P1 P1d P2; do
    loop_mpirun "./field_io_tst 1e-10 < ${SRCDIR}/$x-$Pk.field 2>/dev/null | diff -w -B ${SRCDIR}/$x-$Pk.field - >/dev/null"
    if test $? -ne 0; then status=1; fi
  done
done

exit $status
