"use strict";

// Script purpose : eliminate the accurance of the second scrollbar that
// is triggered by the main document block vertical overload.
// Script calculates maximum free vertical space currently available on the
// page and sets it as the new value for the list of records table
// max-height.
// See mini-default.css appropriate rule for the comments on calc() function
// calculations.
// '105px' is the min-height for the table.
function calcMaxHeight() {
    let root = $('#root').height();
    let head = $('header').outerHeight(true);
    let user = $('#username-card').outerHeight(true) || 0;
    // Take the height of the warnings card into account (while not expanded).
    let warnings_outer = ( ($('div.card.fluid.warning').outerHeight(true)
        - $('div.card.fluid.warning').outerHeight()) / 2.5 ) || 0;
    let warnings = ( $('div.card.fluid.warning').outerHeight()
        + warnings_outer ) || 0;
    // Gets the height of the first element of a kind encountered. No need
    // to set 'id' for the card: in the case o 'db.pl' generated page has only
    // one data card.
    let cf_outer = $('div.card.fluid').outerHeight(true)
        - $('div.card.fluid').height();
    let sf_section = $('#search-form-section').outerHeight(true);
    let sr_outer = $('#search-results-section').outerHeight(true)
        - $('#search-results-section').height();
    let sr_nav = $('#table-nav-panel').outerHeight(true);
    let foot = $('footer').outerHeight(true);
    let free_space = root - head - user - warnings - cf_outer - sf_section
        - sr_outer - sr_nav - foot - 30;
    if( /Google Inc/.test(navigator.vendor) ) {
        free_space -= 5;
    }
    let setsizenew = free_space > 105 ? free_space : 105;
    return setsizenew;
}
// Get the height of an object which is not visible on a page.
function getInvisibleHeight(obj) {
    if ($(obj).length == 0) {
        return false;
    }
    let clone = obj.clone();
    clone.css({
        visibility:'hidden',
        width : '',
        height: '',
        maxWidth : '',
        maxHeight: ''
    });
    $('body').append(clone);
    let height = clone.outerHeight(true);
    clone.remove();
    return height;
}
$(document).ready(function() {
    // Set the main data table height to the maximum available space on
    // the page.
    $('#mydb-table').css('maxHeight',calcMaxHeight());
    // Properly trigger enlarged pictures URL change.
    $(this).on(
      'keydown', function(event) {
          if (event.key == "Escape") {
              let loc = window.location.href;
              // Trigger the change of window URL only in case that the
              // enlarged picture is now active.
              if (/#.+?$/.test(loc)) {
                  window.location.href = "#";
              }
          }
    });
    $(function() {
        $('label.expandable').on("click",function(){
           let labelID = $(this).attr('for');
           // Get the name after 'expandable:' in id. This name is for
           // the div panel that is hidden/set to visible.
           let expandableDivID = labelID.match(/expandable:(.*)/)[1];
           let freeHeightAfterToggle = calcMaxHeight();
           if($('#'+expandableDivID).is(":hidden")) {
               let h = getInvisibleHeight($('#'+expandableDivID));
                // If at the moment of the click event the panel's div is not
                // visible, then  make sure to minimize the data table height
                // according to the panel's height.
               freeHeightAfterToggle -= h;
           } else {
               let objectHeight = $('#'+expandableDivID).outerHeight(true);
                // If at the moment of the click event div is visible, then
                // set the data table height '+' said divs height.
               freeHeightAfterToggle += objectHeight;
           }
           // Update max-height for the data table.
           $('#mydb-table').css('maxHeight',freeHeightAfterToggle);
        });
    });
});
$(window).resize(function (){
    $('#mydb-table').css('maxHeight',calcMaxHeight());
});
$(window).load(function (){
    $('#mydb-table').css('maxHeight',calcMaxHeight());
});
