#! /bin/sh

# Test representation of a table with URLs

TMP_DIR="${TMPDIR}"

test -z "${BIN_DIR}" && BIN_DIR=website/cgi-bin

SCRIPT_BASE=`basename $0 | sed "s/_[0-9]*\.sh$//"`

BASENAME=$(basename $0 .pl)

#BEGIN DEPEND------------------------------------------------------------------

INPUT_SCRIPT="${BIN_DIR}/${SCRIPT_BASE}"

#END DEPEND--------------------------------------------------------------------

set -ue
## set -x

test -z "${TMP_DIR}" && TMP_DIR="/tmp"
TMP_DIR="${TMP_DIR}/tmp-${BASENAME}-$$"
mkdir "${TMP_DIR}"

# To make the trap portable between bash and dash, we need to trap
# "signal" 0 ("EXIT") and rely on it for the cleanup:
## trap "rm -rf '${TMP_DIR}'" 0 1 2 3 15
trap "rm -rf '${TMP_DIR}'" EXIT
trap "exit 1" HUP INT QUIT TERM

export REQUEST_URI='/~saulius/restful/website/localhost.db/bibliography'
export HTTP_HOST=test.domain.net
export REQUEST_METHOD=post
export REMOTE_USER=tester

${INPUT_SCRIPT} format=csv+zip \
    | tail -n +6 > ${TMP_DIR}/template.zip

(
    cd ${TMP_DIR}
    unzip template.zip \
        | grep '^ extracting' \
        | cut -d ' ' -f 3- \
        | while read CSV
          do
              echo ${CSV}:
              cat ${CSV}
          done
)

# Go back to the original directory before deleting the temporary one:
cd - > /dev/null

# Temporary directory will be deleted by the trap.
