#! /usr/bin/env perl

# Test HTMLGenerator

# Check function that forms subresource URIs.

use strict;
use warnings;
use utf8;
use Data::Dumper;

use lib 'lib';
use HTMLGenerator qw(make_subresource_uri);

binmode( STDOUT, "utf8" );

my @cases = (
    [ "new/uri?",            "new", undef ],
    [ "new/uri?already=has", "new", undef ],

    [ "new/uri",             "new", undef ],
    [ "new/uri",             "231", undef ],

    [ "new/uri",             "rec", { append => "extra=value" } ],
    [ "new/uri",             "22",  { append => "extra=value" } ],
    [ "new/uri",             "333", { append => "extra=value&another=value" } ],
    [ "new/uri",             "123", { append => "extra=value&another=value" } ],
);

local $, = "\t";
my $n = 0;
for my $case (@cases) {

    print "test" . ++$n . ":\n";
    print Dumper $case;
    
    eval {
        local $\ = "\n";
        print "", &make_subresource_uri( @{$case} );
    };
    if( $@ ) {
        print $@;
    }
};
