---
title: "Rclone"
description: "rclone syncs files to and from Google Drive, S3, Swift, Cloudfiles, Dropbox, Google Cloud Storage and Amazon Drive."
type: page
date: "2015-09-06"
groups: ["about"]
---

Rclone
======

[![Logo](/img/rclone-120x120.png)](http://rclone.org/)

Rclone is a command line program to sync files and directories to and from

  * Google Drive
  * Amazon S3
  * Openstack Swift / Rackspace cloud files / Memset Memstore
  * Dropbox
  * Google Cloud Storage
  * Amazon Drive
  * Microsoft One Drive
  * Hubic
  * Backblaze B2
  * Yandex Disk
  * SFTP
  * The local filesystem

Features

  * MD5/SHA1 hashes checked at all times for file integrity
  * Timestamps preserved on files
  * Partial syncs supported on a whole file basis
  * [Copy](/commands/rclone_copy/) mode to just copy new/changed files
  * [Sync](/commands/rclone_sync/) (one way) mode to make a directory identical
  * [Check](/commands/rclone_check/) mode to check for file hash equality
  * Can sync to and from network, eg two different cloud accounts
  * Optional encryption ([Crypt](/crypt/))
  * Optional FUSE mount ([rclone mount](/commands/rclone_mount/))

Links

  * <i class="fa fa-home"></i> [Home page](http://rclone.org/)
  * <i class="fa fa-github"></i> [Github project page for source and bug tracker](http://github.com/ncw/rclone)
  * <i class="fa fa-comments"></i> [Rclone Forum](https://forum.rclone.org)
  * <i class="fa fa-google-plus"></i> <a href="https://google.com/+RcloneOrg" rel="publisher">Google+ page</a>
  * <i class="fa fa-cloud-download"></i>[Downloads](/downloads/)
