% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{ATT}
\alias{ATT}
\title{Compute simulated (sample) average treatment effects on the treated from
a Zelig model estimation}
\usage{
ATT(object, treatment, treated = 1, num = NULL)
}
\arguments{
\item{object}{an object of class Zelig}

\item{treatment}{character string naming the variable that denotes the
treatment and non-treated groups.}

\item{treated}{value of \code{treatment} variable indicating treatment}

\item{num}{number of simulations to run. Default is 1000.}
}
\description{
Compute simulated (sample) average treatment effects on the treated from
a Zelig model estimation
}
\examples{
library(dplyr)
data(sanction)
z.att <- zelig(num ~ target + coop + mil, model = "poisson",
                 data = sanction) \%>\%
             ATT(treatment = "mil") \%>\%
             get_qi(qi = "ATT", xvalue = "TE")

}
\author{
Christopher Gandrud
}
