% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nperiods.R
\name{nseconds}
\alias{nseconds}
\alias{nminutes}
\alias{nhours}
\alias{ndays}
\alias{nweeks}
\alias{nmonths}
\alias{nquarters}
\alias{nyears}
\title{Number of Periods in Data}
\usage{
nseconds(x)

nminutes(x)

nhours(x)

ndays(x)

nweeks(x)

nmonths(x)

nquarters(x)

nyears(x)
}
\arguments{
\item{x}{A time-based object.}
}
\value{
The number of respective periods in \code{x}.
}
\description{
Calculate the number of specified periods in a given time series like data
object.
}
\details{
Essentially a wrapper to \code{endpoints()} with the appropriate period
specified. The result is the number of endpoints found.

As a compromise between simplicity and accuracy, the results will always
round up to the nearest complete period. Subtract 1 from the result to
get the completed periods.

For finer grain detail one should call the higher frequency functions.

An alternative summary can be found with \code{periodicity(x)} and
\code{unclass(periodicity(x))}.
}
\examples{

\dontrun{
getSymbols("QQQQ")

ndays(QQQQ)
nweeks(QQQQ)
}

}
\seealso{
\code{\link[=endpoints]{endpoints()}}
}
\author{
Jeffrey A. Ryan
}
\keyword{utilities}
