% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/problems.R
\name{problems}
\alias{problems}
\title{Retrieve parsing problems}
\usage{
problems(x = .Last.value, lazy = FALSE)
}
\arguments{
\item{x}{A data frame from \code{vroom::vroom()}.}

\item{lazy}{If \code{TRUE}, just the problems found so far are returned. If
\code{FALSE} (the default) the lazy data is first read completely and all
problems are returned.}
}
\value{
A data frame with one row for each problem and four columns:
\itemize{
\item row,col - Row and column number that caused the problem, referencing the
original input
\item expected - What vroom expected to find
\item actual - What it actually found
\item file - The file with the problem
}
}
\description{
vroom will only fail to parse a file if the file is invalid in a way that is
unrecoverable. However there are a number of non-fatal problems that you
might want to know about. You can retrieve a data frame of these problems
with this function.
}
