% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group.R
\name{vec_group}
\alias{vec_group}
\alias{vec_group_id}
\alias{vec_group_loc}
\alias{vec_group_rle}
\title{Identify groups}
\usage{
vec_group_id(x)

vec_group_loc(x)

vec_group_rle(x)
}
\arguments{
\item{x}{A vector}
}
\value{
\itemize{
\item \code{vec_group_id()}: An integer vector with the same size as \code{x}.
\item \code{vec_group_loc()}: A two column data frame with size equal to
\code{vec_size(vec_unique(x))}.
\itemize{
\item A \code{key} column of type \code{vec_ptype(x)}
\item A \code{loc} column of type list, with elements of type integer.
}
\item \code{vec_group_rle()}: A \code{vctrs_group_rle} rcrd object with two integer
vector fields: \code{group} and \code{length}.
}

Note that when using \code{vec_group_loc()} for complex types, the default
\code{data.frame} print method will be suboptimal, and you will want to coerce
into a tibble to better understand the output.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
\itemize{
\item \code{vec_group_id()} returns an identifier for the group that each element of
\code{x} falls in, constructed in the order that they appear. The number of
groups is also returned as an attribute, \code{n}.
\item \code{vec_group_loc()} returns a data frame containing a \code{key} column with the
unique groups, and a \code{loc} column with the locations of each group in \code{x}.
\item \code{vec_group_rle()} locates groups in \code{x} and returns them run length
encoded in the order that they appear. The return value is a rcrd object
with fields for the \code{group} identifiers and the run \code{length} of the
corresponding group. The number of groups is also returned as an
attribute, \code{n}.
}
}
\section{Dependencies}{

\itemize{
\item \code{\link[=vec_proxy_equal]{vec_proxy_equal()}}
}
}

\examples{
purrr <- c("p", "u", "r", "r", "r")
vec_group_id(purrr)
vec_group_rle(purrr)

groups <- mtcars[c("vs", "am")]
vec_group_id(groups)

group_rle <- vec_group_rle(groups)
group_rle

# Access fields with `field()`
field(group_rle, "group")
field(group_rle, "length")

# `vec_group_id()` is equivalent to
vec_match(groups, vec_unique(groups))

vec_group_loc(mtcars$vs)
vec_group_loc(mtcars[c("vs", "am")])

if (require("tibble")) {
  as_tibble(vec_group_loc(mtcars[c("vs", "am")]))
}
}
\keyword{internal}
