% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/names.R
\name{vec_as_names_legacy}
\alias{vec_as_names_legacy}
\title{Repair names with legacy method}
\usage{
vec_as_names_legacy(names, prefix = "V", sep = "")
}
\arguments{
\item{names}{A character vector.}

\item{prefix, sep}{Prefix and separator for repaired names.}
}
\description{
This standardises names with the legacy approach that was used in
tidyverse packages (such as tibble, tidyr, and readxl) before
\code{\link[=vec_as_names]{vec_as_names()}} was implemented. This tool is meant to help
transitioning to the new name repairing standard and will be
deprecated and removed from the package some time in the future.
}
\examples{
if (rlang::is_installed("tibble")) {

library(tibble)

# Names repair is turned off by default in tibble:
try(tibble(a = 1, a = 2))

# You can turn it on by supplying a repair method:
tibble(a = 1, a = 2, .name_repair = "universal")

# If you prefer the legacy method, use `vec_as_names_legacy()`:
tibble(a = 1, a = 2, .name_repair = vec_as_names_legacy)

}
}
\keyword{internal}
