/* This file is automatically generated. DO NOT EDIT!
   Instead, edit gen-charwidth.py and re-run.  */

/*
 * Unicode East_Asian_Width property values.
 *
 * Defined in UAX #11 "East Asian Width"
 *
 *     http://www.unicode.org/reports/tr11/
 *
 * We use the two-stage lookup strategy described at
 *
 *     http://www.strchr.com/multi-stage_tables
 *
 */

#ifndef CHARWIDTH_H
#define CHARWIDTH_H

#include <stdint.h>

enum charwidth_prop {
	CHARWIDTH_NONE = 0,
	CHARWIDTH_IGNORABLE = 1,
	CHARWIDTH_MARK = 2,
	CHARWIDTH_NARROW = 3,
	CHARWIDTH_AMBIGUOUS = 4,
	CHARWIDTH_WIDE = 5,
	CHARWIDTH_EMOJI = 6
};

static const uint8_t charwidth_stage1[] = {
/* U+0000 */  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
/* U+0800 */ 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
/* U+1000 */ 32, 33, 34, 35, 36, 37, 38, 39, 35, 35, 35, 35, 35, 40, 41, 42,
/* U+1800 */ 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 35, 53, 35, 35, 54, 55,
/* U+2000 */ 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71,
/* U+2800 */ 35, 35, 72, 35, 35, 35, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82,
/* U+3000 */ 83, 84, 85, 86, 87, 88, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
/* U+3800 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
/* U+4000 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
/* U+4800 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 89, 81, 81, 81, 81,
/* U+5000 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
/* U+5800 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
/* U+6000 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
/* U+6800 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
/* U+7000 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
/* U+7800 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
/* U+8000 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
/* U+8800 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
/* U+9000 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
/* U+9800 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 90,
/* U+A000 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 91, 35, 35, 92, 93, 35, 94,
/* U+A800 */ 95, 96, 97, 98, 99,100,101,102, 81, 81, 81, 81, 81, 81, 81, 81,
/* U+B000 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
/* U+B800 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
/* U+C000 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
/* U+C800 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
/* U+D000 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,103,
/* U+D800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+E000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+E800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+F000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+F800 */104,104, 81, 81,105,106,107,108, 35, 35,109,110,111,112,113,114,
/* U+10000 */115,116,117,118,104,119,120,121, 35,122,123,104, 35, 35,124,104,
/* U+10800 */125,126,127,128,129,130,131,132,133,134,104,104,135,104,104,104,
/* U+11000 */136,137,138,139,140,141,142,104,143,144,104,145,146,147,148,104,
/* U+11800 */104,149,104,104,150,151,104,104,152,153,154,104,104,104,104,104,
/* U+12000 */ 35, 35, 35, 35, 35, 35, 35,155,156, 35,157,104,104,104,104,104,
/* U+12800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+13000 */ 35, 35, 35, 35, 35, 35, 35, 35,158,104,104,104,104,104,104,104,
/* U+13800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+14000 */104,104,104,104,104,104,104,104, 35, 35, 35, 35,159,104,104,104,
/* U+14800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+15000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+15800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+16000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+16800 */ 35, 35, 35, 35,160,161,162,163,104,104,104,104,104,104,164,165,
/* U+17000 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
/* U+17800 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
/* U+18000 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,166,
/* U+18800 */ 81, 81, 81, 81, 81,167,104,104,104,104,104,104,104,104,104,104,
/* U+19000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+19800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+1A000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+1A800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+1B000 */ 81, 81,168, 81, 81,169,104,104,104,104,104,104,104,104,104,104,
/* U+1B800 */104,104,104,104,104,104,104,104,170,171,104,104,104,104,104,104,
/* U+1C000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+1C800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+1D000 */ 35,172,173,174,175,104,176,104,177,178,179, 35, 35,180, 35,181,
/* U+1D800 */ 35, 35, 35, 35,182,183,104,104,104,104,104,104,104,104,104,104,
/* U+1E000 */184,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+1E800 */ 35,185,186,104,104,104,104,104,104,104,104,104,187,188,104,104,
/* U+1F000 */189,190,191,192,193,104,194,195,196,197,198,199,200,201,202,203,
/* U+1F800 */204,205,206,207,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+20000 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
/* U+20800 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
/* U+21000 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
/* U+21800 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
/* U+22000 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
/* U+22800 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
/* U+23000 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
/* U+23800 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
/* U+24000 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
/* U+24800 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
/* U+25000 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
/* U+25800 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
/* U+26000 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
/* U+26800 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
/* U+27000 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
/* U+27800 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
/* U+28000 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
/* U+28800 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
/* U+29000 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
/* U+29800 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
/* U+2A000 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,208, 81, 81,
/* U+2A800 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
/* U+2B000 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,209, 81,
/* U+2B800 */210, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
/* U+2C000 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
/* U+2C800 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,211, 81, 81,
/* U+2D000 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
/* U+2D800 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
/* U+2E000 */ 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81,
/* U+2E800 */ 81, 81, 81, 81, 81, 81, 81,212,104,104,104,104,104,104,104,104,
/* U+2F000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+2F800 */ 81, 81, 81, 81,213,104,104,104,104,104,104,104,104,104,104,104,
/* U+30000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+30800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+31000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+31800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+32000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+32800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+33000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+33800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+34000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+34800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+35000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+35800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+36000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+36800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+37000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+37800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+38000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+38800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+39000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+39800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+3A000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+3A800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+3B000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+3B800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+3C000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+3C800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+3D000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+3D800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+3E000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+3E800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+3F000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+3F800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+40000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+40800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+41000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+41800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+42000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+42800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+43000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+43800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+44000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+44800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+45000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+45800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+46000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+46800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+47000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+47800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+48000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+48800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+49000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+49800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+4A000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+4A800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+4B000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+4B800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+4C000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+4C800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+4D000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+4D800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+4E000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+4E800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+4F000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+4F800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+50000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+50800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+51000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+51800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+52000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+52800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+53000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+53800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+54000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+54800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+55000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+55800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+56000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+56800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+57000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+57800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+58000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+58800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+59000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+59800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+5A000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+5A800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+5B000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+5B800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+5C000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+5C800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+5D000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+5D800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+5E000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+5E800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+5F000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+5F800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+60000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+60800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+61000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+61800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+62000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+62800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+63000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+63800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+64000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+64800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+65000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+65800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+66000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+66800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+67000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+67800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+68000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+68800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+69000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+69800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+6A000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+6A800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+6B000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+6B800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+6C000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+6C800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+6D000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+6D800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+6E000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+6E800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+6F000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+6F800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+70000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+70800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+71000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+71800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+72000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+72800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+73000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+73800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+74000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+74800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+75000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+75800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+76000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+76800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+77000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+77800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+78000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+78800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+79000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+79800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+7A000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+7A800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+7B000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+7B800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+7C000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+7C800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+7D000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+7D800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+7E000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+7E800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+7F000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+7F800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+80000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+80800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+81000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+81800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+82000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+82800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+83000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+83800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+84000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+84800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+85000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+85800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+86000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+86800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+87000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+87800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+88000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+88800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+89000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+89800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+8A000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+8A800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+8B000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+8B800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+8C000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+8C800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+8D000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+8D800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+8E000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+8E800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+8F000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+8F800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+90000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+90800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+91000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+91800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+92000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+92800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+93000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+93800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+94000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+94800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+95000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+95800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+96000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+96800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+97000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+97800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+98000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+98800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+99000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+99800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+9A000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+9A800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+9B000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+9B800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+9C000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+9C800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+9D000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+9D800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+9E000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+9E800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+9F000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+9F800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+A0000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+A0800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+A1000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+A1800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+A2000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+A2800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+A3000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+A3800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+A4000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+A4800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+A5000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+A5800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+A6000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+A6800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+A7000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+A7800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+A8000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+A8800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+A9000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+A9800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+AA000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+AA800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+AB000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+AB800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+AC000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+AC800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+AD000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+AD800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+AE000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+AE800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+AF000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+AF800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+B0000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+B0800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+B1000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+B1800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+B2000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+B2800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+B3000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+B3800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+B4000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+B4800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+B5000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+B5800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+B6000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+B6800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+B7000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+B7800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+B8000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+B8800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+B9000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+B9800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+BA000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+BA800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+BB000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+BB800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+BC000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+BC800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+BD000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+BD800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+BE000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+BE800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+BF000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+BF800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+C0000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+C0800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+C1000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+C1800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+C2000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+C2800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+C3000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+C3800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+C4000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+C4800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+C5000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+C5800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+C6000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+C6800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+C7000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+C7800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+C8000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+C8800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+C9000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+C9800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+CA000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+CA800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+CB000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+CB800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+CC000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+CC800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+CD000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+CD800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+CE000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+CE800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+CF000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+CF800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+D0000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+D0800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+D1000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+D1800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+D2000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+D2800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+D3000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+D3800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+D4000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+D4800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+D5000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+D5800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+D6000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+D6800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+D7000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+D7800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+D8000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+D8800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+D9000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+D9800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+DA000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+DA800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+DB000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+DB800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+DC000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+DC800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+DD000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+DD800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+DE000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+DE800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+DF000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+DF800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+E0000 */214,214,214,214,214,214,214,214,214,214,214,214,214,214,214,214,
/* U+E0800 */214,214,214,214,214,214,214,214,214,214,214,214,214,214,214,214,
/* U+E1000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+E1800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+E2000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+E2800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+E3000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+E3800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+E4000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+E4800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+E5000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+E5800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+E6000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+E6800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+E7000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+E7800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+E8000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+E8800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+E9000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+E9800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+EA000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+EA800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+EB000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+EB800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+EC000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+EC800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+ED000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+ED800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+EE000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+EE800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+EF000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+EF800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+F0000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+F0800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+F1000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+F1800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+F2000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+F2800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+F3000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+F3800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+F4000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+F4800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+F5000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+F5800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+F6000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+F6800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+F7000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+F7800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+F8000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+F8800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+F9000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+F9800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+FA000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+FA800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+FB000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+FB800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+FC000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+FC800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+FD000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+FD800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+FE000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+FE800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+FF000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+FF800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+100000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+100800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+101000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+101800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+102000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+102800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+103000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+103800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+104000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+104800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+105000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+105800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+106000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+106800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+107000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+107800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+108000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+108800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+109000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+109800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+10A000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+10A800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+10B000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+10B800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+10C000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+10C800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+10D000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+10D800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+10E000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+10E800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+10F000 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
/* U+10F800 */104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104
};

static const int8_t charwidth_stage2[][128] = {
  /* block 0 */
  {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0
  },

  /* block 1 */
  {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  4,  3,  3,  4,  3,  3,  4,  4,  3,  4,  3,  3,  1,  4,  3,
     4,  4,  4,  4,  4,  3,  4,  4,  4,  4,  4,  3,  4,  4,  4,  4,
     3,  3,  3,  3,  3,  3,  4,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     4,  3,  3,  3,  3,  3,  3,  4,  4,  3,  3,  3,  3,  3,  4,  4,
     4,  4,  3,  3,  3,  3,  4,  3,  4,  4,  4,  3,  4,  4,  3,  3,
     4,  3,  4,  4,  3,  3,  3,  4,  4,  4,  4,  3,  4,  3,  4,  3
  },

  /* block 2 */
  {  3,  4,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  4,  3,  4,  3,  3,  3,  3,  3,  3,  3,  4,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  4,  4,  3,  3,  3,  4,  3,  3,  3,  3,
     3,  4,  4,  4,  3,  3,  3,  3,  4,  3,  3,  3,  3,  3,  3,  4,
     4,  4,  4,  3,  4,  3,  3,  3,  4,  4,  4,  4,  3,  4,  3,  3,
     3,  3,  4,  4,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  4,  4,  3,  3,  3,  4,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 3 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  4,  3,
     4,  3,  4,  3,  4,  3,  4,  3,  4,  3,  4,  3,  4,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 4 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  4,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  4,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 5 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  4,  3,  3,  4,  3,  4,  4,  4,  3,  4,  3,  3,
     4,  3,  3,  3,  3,  3,  3,  3,  4,  4,  4,  4,  3,  4,  3,  4,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 6 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  1,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  3,  3,  3,  3,  3,  3
  },

  /* block 7 */
  {  0,  0,  0,  0,  3,  3,  3,  3,  3,  3,  3,  0,  3,  0,  3,  3,
     3,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  0,  4,  4,  4,  4,  4,  4,  4,  3,  3,  3,  3,  3,  3,
     3,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  3,  4,  4,  4,  4,  4,  4,  4,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 8 */
  {  3,  4,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     3,  4,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 9 */
  {  3,  3,  3,  2,  2,  2,  2,  2,  2,  2,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 10 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     0,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  0,  0,  3,  3,  3,  3,  3,  3,  3,
     0,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 11 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  0,  3,  3,  0,  0,  3,  3,  3,
     0,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  3,  2,
     3,  2,  2,  3,  2,  2,  3,  2,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 12 */
  {  2,  2,  2,  2,  2,  2,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  3,  1,  0,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     2,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 13 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  2,  2,  2,  2,  2,  2,  2,  2,  3,  2,
     2,  2,  2,  2,  2,  3,  3,  2,  2,  3,  2,  2,  2,  2,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 14 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  2,
     3,  2,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  0,  0,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 15 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0
  },

  /* block 16 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  2,  2,  2,  2,  3,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  3,  2,  2,  2,  3,  2,  2,  2,  2,  2,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  2,  2,  2,  0,  0,  3,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 17 */
  {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  0,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 18 */
  {  2,  2,  2,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  2,  3,  2,  3,  3,  3,
     3,  2,  2,  2,  2,  2,  2,  2,  2,  3,  3,  3,  3,  2,  3,  3,
     3,  2,  2,  2,  2,  2,  2,  2,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  2,  2,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 19 */
  {  3,  2,  3,  3,  0,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  3,
     3,  0,  0,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  3,  3,  3,  3,  3,  3,
     3,  0,  3,  0,  0,  0,  3,  3,  3,  3,  0,  0,  2,  3,  3,  3,
     3,  2,  2,  2,  2,  0,  0,  3,  3,  0,  0,  3,  3,  2,  3,  0,
     0,  0,  0,  0,  0,  0,  0,  3,  0,  0,  0,  0,  3,  3,  0,  3,
     3,  3,  2,  2,  0,  0,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0
  },

  /* block 20 */
  {  0,  2,  2,  3,  0,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  3,
     3,  0,  0,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  3,  3,  3,  3,  3,  3,
     3,  0,  3,  3,  0,  3,  3,  0,  3,  3,  0,  0,  2,  0,  3,  3,
     3,  2,  2,  0,  0,  0,  0,  2,  2,  0,  0,  2,  2,  2,  0,  0,
     0,  2,  0,  0,  0,  0,  0,  0,  0,  3,  3,  3,  3,  0,  3,  0,
     0,  0,  0,  0,  0,  0,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     2,  2,  3,  3,  3,  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 21 */
  {  0,  2,  2,  3,  0,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  3,
     3,  3,  0,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  3,  3,  3,  3,  3,  3,
     3,  0,  3,  3,  0,  3,  3,  3,  3,  3,  0,  0,  2,  3,  3,  3,
     3,  2,  2,  2,  2,  2,  0,  2,  2,  3,  0,  3,  3,  2,  0,  0,
     3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  2,  2,  0,  0,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  0,  0,  0,  0,  0,  0,  0,  3,  2,  2,  2,  2,  2,  2
  },

  /* block 22 */
  {  0,  2,  3,  3,  0,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  3,
     3,  0,  0,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  3,  3,  3,  3,  3,  3,
     3,  0,  3,  3,  0,  3,  3,  3,  3,  3,  0,  0,  2,  3,  3,  2,
     3,  2,  2,  2,  2,  0,  0,  3,  3,  0,  0,  3,  3,  2,  0,  0,
     0,  0,  0,  0,  0,  0,  2,  3,  0,  0,  0,  0,  3,  3,  0,  3,
     3,  3,  2,  2,  0,  0,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 23 */
  {  0,  0,  2,  3,  0,  3,  3,  3,  3,  3,  3,  0,  0,  0,  3,  3,
     3,  0,  3,  3,  3,  3,  0,  0,  0,  3,  3,  0,  3,  0,  3,  3,
     0,  0,  0,  3,  3,  0,  0,  0,  3,  3,  3,  0,  0,  0,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  3,  3,
     2,  3,  3,  0,  0,  0,  3,  3,  3,  0,  3,  3,  3,  2,  0,  0,
     3,  0,  0,  0,  0,  0,  0,  3,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0
  },

  /* block 24 */
  {  2,  3,  3,  3,  0,  3,  3,  3,  3,  3,  3,  3,  3,  0,  3,  3,
     3,  0,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  3,  2,  2,
     2,  3,  3,  3,  3,  0,  2,  2,  2,  0,  2,  2,  2,  2,  0,  0,
     0,  0,  0,  0,  0,  2,  2,  0,  3,  3,  3,  0,  0,  0,  0,  0,
     3,  3,  2,  2,  0,  0,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     0,  0,  0,  0,  0,  0,  0,  0,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 25 */
  {  3,  2,  3,  3,  0,  3,  3,  3,  3,  3,  3,  3,  3,  0,  3,  3,
     3,  0,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  0,  3,  3,  3,  3,  3,  0,  0,  2,  3,  3,  2,
     3,  3,  3,  3,  3,  0,  2,  3,  3,  0,  3,  3,  2,  2,  0,  0,
     0,  0,  0,  0,  0,  3,  3,  0,  0,  0,  0,  0,  0,  0,  3,  0,
     3,  3,  2,  2,  0,  0,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     0,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 26 */
  {  2,  2,  3,  3,  0,  3,  3,  3,  3,  3,  3,  3,  3,  0,  3,  3,
     3,  0,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  2,  2,  3,  3,  3,
     3,  2,  2,  2,  2,  0,  3,  3,  3,  0,  3,  3,  3,  2,  3,  3,
     0,  0,  0,  0,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  2,  2,  0,  0,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 27 */
  {  0,  0,  3,  3,  0,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  0,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  3,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  2,  0,  0,  0,  0,  3,
     3,  3,  2,  2,  2,  0,  2,  0,  3,  3,  3,  3,  3,  3,  3,  3,
     0,  0,  0,  0,  0,  0,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     0,  0,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 28 */
  {  0,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  2,  3,  3,  2,  2,  2,  2,  2,  2,  2,  0,  0,  0,  0,  3,
     3,  3,  3,  3,  3,  3,  3,  2,  2,  2,  2,  2,  2,  2,  2,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 29 */
  {  0,  3,  3,  0,  3,  0,  0,  3,  3,  0,  3,  0,  0,  3,  0,  0,
     0,  0,  0,  0,  3,  3,  3,  3,  0,  3,  3,  3,  3,  3,  3,  3,
     0,  3,  3,  3,  0,  3,  0,  3,  0,  0,  3,  3,  0,  3,  3,  3,
     3,  2,  3,  3,  2,  2,  2,  2,  2,  2,  0,  2,  2,  3,  0,  0,
     3,  3,  3,  3,  3,  0,  3,  0,  2,  2,  2,  2,  2,  2,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  3,  3,  3,  3,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 30 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  2,  2,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  2,  3,  2,  3,  2,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  0,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,
     0,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  3
  },

  /* block 31 */
  {  2,  2,  2,  2,  2,  3,  2,  2,  3,  3,  3,  3,  3,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  0,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  0,  3,  3,
     3,  3,  3,  3,  3,  3,  2,  3,  3,  3,  3,  3,  3,  0,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 32 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  2,  2,  2,
     2,  3,  2,  2,  2,  2,  2,  2,  3,  2,  2,  3,  3,  2,  2,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  2,  2,  3,  3,  3,  3,  2,  2,
     2,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  2,  2,  2,  2,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 33 */
  {  3,  3,  2,  3,  3,  2,  2,  3,  3,  3,  3,  3,  3,  2,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  2,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  0,  3,  0,  0,  0,  0,  0,  3,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 34 */
  {  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  1,
     1,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 35 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 36 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  3,  3,  3,  3,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  0,  3,  0,  3,  3,  3,  3,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 37 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  3,  3,  3,  3,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  0,  3,  3,  3,  3,  0,  0,  3,  3,  3,  3,  3,  3,  3,  0,
     3,  0,  3,  3,  3,  3,  0,  0,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  0,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 38 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  0,  3,  3,  3,  3,  0,  0,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  2,  2,  2,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0
  },

  /* block 39 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  0,  0,  3,  3,  3,  3,  3,  3,  0,  0
  },

  /* block 40 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 41 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  3,  3,
     3,  3,  2,  2,  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  2,  2,  2,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  2,  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  3,  3,
     3,  0,  2,  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 42 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  1,  1,  3,  2,  2,  2,  2,  2,  2,  2,  3,  3,
     3,  3,  3,  3,  3,  3,  2,  3,  3,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  3,  3,  3,  3,  3,  3,  3,  3,  3,  2,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0
  },

  /* block 43 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  1,  1,  1,  1,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 44 */
  {  3,  3,  3,  3,  3,  2,  2,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  2,  3,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 45 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,
     2,  2,  2,  3,  3,  3,  3,  2,  2,  3,  3,  3,  0,  0,  0,  0,
     3,  3,  2,  3,  3,  3,  3,  3,  3,  2,  2,  2,  0,  0,  0,  0,
     3,  0,  0,  0,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,
     3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 46 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 47 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  2,  2,  3,  3,  2,  0,  0,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  2,  3,  2,  2,  2,  2,  2,  2,  2,  0,
     2,  3,  2,  3,  3,  2,  2,  2,  2,  2,  2,  2,  2,  3,  3,  3,
     3,  3,  3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  0,  0,  2
  },

  /* block 48 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 49 */
  {  2,  2,  2,  2,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  2,  3,  2,  2,  2,  2,  2,  3,  2,  3,  3,  3,
     3,  3,  2,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0
  },

  /* block 50 */
  {  2,  2,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  2,  2,  2,  2,  3,  3,  2,  2,  3,  2,  2,  2,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  2,  3,  2,  2,  3,  3,  3,  2,  3,  2,
     2,  2,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,  3,  3,  3,  3
  },

  /* block 51 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  2,  2,  2,  2,
     2,  2,  2,  2,  3,  3,  2,  2,  0,  0,  0,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 52 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,
     2,  2,  2,  3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  3,  2,  2,  2,  2,  2,  2,  2,  3,  3,  3,  3,  2,  3,  3,
     3,  3,  3,  3,  2,  3,  3,  3,  2,  2,  0,  0,  0,  0,  0,  0
  },

  /* block 53 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  0,  2,  2,  2,  2,  2
  },

  /* block 54 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  0,  0,  3,  3,  3,  3,  3,  3,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  0,  0,  3,  3,  3,  3,  3,  3,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  0,  3,  0,  3,  0,  3,  0,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0
  },

  /* block 55 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  0,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  0,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  0,  0,  3,  3,  3,  3,  3,  3,  0,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     0,  0,  3,  3,  3,  0,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0
  },

  /* block 56 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  1,  1,  1,  1,  1,
     4,  3,  3,  4,  4,  4,  4,  3,  4,  4,  3,  3,  4,  4,  3,  3,
     4,  4,  4,  3,  4,  4,  4,  4,  0,  0,  1,  1,  1,  1,  1,  3,
     4,  3,  4,  4,  3,  4,  3,  3,  3,  3,  3,  4,  3,  3,  4,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     3,  3,  0,  0,  4,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  4
  },

  /* block 57 */
  {  3,  4,  4,  4,  4,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  4,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 58 */
  {  3,  3,  3,  4,  3,  4,  3,  3,  3,  4,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  4,  3,  3,  4,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  4,  4,  3,  3,  3,  4,  3,  3,  3,  3,  4,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  6,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  4,  4,  3,  3,  3,  3,  3,  3,  4,  4,  4,  4,  3,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  3,  3,  3,  3,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  3,  3,  3,  3,  3,  3
  },

  /* block 59 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  4,  3,  3,  0,  0,  0,  0,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  6,  6,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  4,  4,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  4,  3,  4,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  4,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 60 */
  {  4,  3,  4,  4,  3,  3,  3,  4,  4,  3,  3,  4,  3,  3,  3,  4,
     3,  4,  3,  3,  3,  4,  3,  3,  3,  3,  4,  3,  3,  4,  4,  4,
     4,  3,  3,  4,  3,  4,  3,  4,  4,  4,  4,  4,  4,  3,  4,  3,
     3,  3,  3,  3,  4,  4,  4,  4,  3,  3,  3,  3,  4,  4,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  4,  3,  3,  3,  4,  3,  3,  3,
     3,  3,  4,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     4,  4,  3,  3,  4,  4,  4,  4,  3,  3,  4,  4,  3,  3,  4,  4,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 61 */
  {  3,  3,  4,  4,  3,  3,  4,  4,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  4,  3,  3,  3,  4,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  4,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  4,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 62 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  4,  3,  3,  3,  3,  3,  3,  3,  6,  6,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  6,  5,  5,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 63 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  6,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  3,  3,  3,  3,  6,  6,  6,  3,  3,  3,  3,  3
  },

  /* block 64 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4
  },

  /* block 65 */
  {  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  6,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  3,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4
  },

  /* block 66 */
  {  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  3,  3,  3,  3,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 67 */
  {  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     3,  3,  4,  4,  4,  4,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     4,  4,  3,  4,  4,  4,  4,  4,  4,  4,  3,  3,  3,  3,  3,  3,
     3,  3,  4,  4,  3,  3,  4,  4,  3,  3,  3,  3,  4,  4,  3,  3,
     4,  4,  3,  3,  3,  3,  4,  4,  4,  3,  3,  4,  3,  3,  4,  4,
     4,  4,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  4,  4,  4,  4,  3,  3,  3,  3,  3,  3,  3,  3,  3,  4,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  6,  6,  6,  6,  3
  },

  /* block 68 */
  {  6,  6,  6,  6,  6,  4,  4,  3,  3,  4,  3,  3,  3,  3,  6,  4,
     3,  6,  3,  3,  6,  6,  3,  3,  6,  3,  3,  3,  4,  6,  4,  3,
     6,  3,  6,  6,  3,  3,  6,  3,  3,  3,  6,  3,  3,  3,  6,  6,
     3,  3,  3,  3,  3,  3,  3,  3,  6,  6,  6,  3,  3,  3,  3,  3,
     4,  3,  4,  3,  3,  3,  3,  3,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     4,  4,  3,  4,  4,  4,  3,  4,  6,  4,  4,  3,  4,  4,  3,  4,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  6,  3,  3,  3,  6
  },

  /* block 69 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  6,  6,  6,  6,  6,  6,  3,  6,  3,  6,  6,  3,  4,  4,
     6,  6,  3,  3,  3,  3,  3,  3,  3,  3,  6,  6,  3,  3,  3,  3,
     6,  6,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  6,  6,  4,
     3,  3,  3,  3,  6,  6,  4,  4,  6,  4,  4,  4,  4,  4,  6,  6,
     4,  6,  4,  6,  6,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  3,  4,  3,  3,  3,  3,  4,  6,  6,  4,  4,  4,  4,  4,
     6,  6,  6,  6,  6,  6,  4,  6,  6,  6,  6,  4,  4,  6,  4,  4
  },

  /* block 70 */
  {  3,  3,  6,  3,  3,  6,  3,  3,  6,  6,  6,  6,  6,  6,  3,  6,
     3,  3,  6,  3,  6,  3,  6,  3,  3,  3,  3,  3,  3,  6,  3,  3,
     3,  6,  3,  3,  3,  3,  3,  3,  6,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  6,  6,  3,  3,  3,  3,  3,  3,  3,  3,  4,  3,  3,
     3,  3,  3,  3,  6,  3,  3,  6,  3,  3,  3,  3,  6,  3,  6,  3,
     3,  3,  3,  6,  6,  6,  3,  6,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  6,  6,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4
  },

  /* block 71 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  6,  6,  6,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  6,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     6,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  6,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 72 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  6,  6,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 73 */
  {  3,  3,  3,  3,  3,  6,  6,  6,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  6,  6,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     6,  3,  3,  3,  3,  6,  4,  4,  4,  4,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  0,  0,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 74 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  0,  0,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  3,  3,  3,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 75 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 76 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  2,
     2,  2,  3,  3,  0,  0,  0,  0,  0,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 77 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  0,  3,  0,  0,  0,  0,  0,  3,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  3,
     3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  2
  },

  /* block 78 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  0,  3,  3,  3,  3,  3,  3,  3,  0,
     3,  3,  3,  3,  3,  3,  3,  0,  3,  3,  3,  3,  3,  3,  3,  0,
     3,  3,  3,  3,  3,  3,  3,  0,  3,  3,  3,  3,  3,  3,  3,  0,
     3,  3,  3,  3,  3,  3,  3,  0,  3,  3,  3,  3,  3,  3,  3,  0,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2
  },

  /* block 79 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 80 */
  {  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  0,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 81 */
  {  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5
  },

  /* block 82 */
  {  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  0,  0,  0,  0
  },

  /* block 83 */
  {  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  2,  2,  2,  2,  5,  5,
     6,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  6,  5,  3,
     0,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5
  },

  /* block 84 */
  {  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  0,  0,  2,  2,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5
  },

  /* block 85 */
  {  0,  0,  0,  0,  0,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  0,
     0,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  1,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5
  },

  /* block 86 */
  {  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  0,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  0,  0,  0,  0,  0,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5
  },

  /* block 87 */
  {  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  0,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  4,  4,  4,  4,  4,  4,  4,  4,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5
  },

  /* block 88 */
  {  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  6,  5,  6,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  0
  },

  /* block 89 */
  {  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 90 */
  {  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 91 */
  {  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  0,  0,  0,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 92 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  2,
     2,  2,  2,  3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  3,  3
  },

  /* block 93 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  2,  2,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     2,  2,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 94 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 95 */
  {  3,  3,  2,  3,  3,  3,  2,  3,  3,  3,  3,  2,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  2,  2,  3,  3,  3,  3,  3,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 96 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  2,  2,  0,  0,  0,  0,  0,  0,  0,  0,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0
  },

  /* block 97 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  2,  2,  2,  2,  2,  2,  2,  2,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  0,  0,  0
  },

  /* block 98 */
  {  2,  2,  2,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  2,  3,  3,  2,  2,  2,  2,  3,  3,  2,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  3,  3,
     3,  3,  3,  3,  3,  2,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0
  },

  /* block 99 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  2,  2,  2,  2,  2,  2,  3,
     3,  2,  2,  3,  3,  2,  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  2,  3,  3,  3,  3,  3,  3,  3,  3,  2,  3,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  2,  3,  3,  3
  },

  /* block 100 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     2,  3,  2,  2,  2,  3,  3,  2,  2,  3,  3,  3,  3,  3,  2,  2,
     3,  2,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  2,  2,  3,  3,
     3,  3,  3,  3,  3,  3,  2,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 101 */
  {  0,  3,  3,  3,  3,  3,  3,  0,  0,  3,  3,  3,  3,  3,  3,  0,
     0,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  0,  3,  3,  3,  3,  3,  3,  3,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 102 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  2,  3,  3,  2,  3,  3,  3,  3,  2,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0
  },

  /* block 103 */
  {  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0
  },

  /* block 104 */
  {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 105 */
  {  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  0,  0,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5
  },

  /* block 106 */
  {  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 107 */
  {  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  3,  2,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  0,  3,  3,  3,  3,  3,  0,  3,  0,
     3,  3,  0,  3,  3,  0,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 108 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 109 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 110 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     0,  0,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0
  },

  /* block 111 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  0,  0,  0,  0,  0,  0,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  0,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  0,  5,  5,  5,  5,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  0,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 112 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  1
  },

  /* block 113 */
  {  0,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 114 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     1,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,
     0,  0,  3,  3,  3,  3,  3,  3,  0,  0,  3,  3,  3,  3,  3,  3,
     0,  0,  3,  3,  3,  3,  3,  3,  0,  0,  3,  3,  3,  0,  0,  0,
     5,  5,  5,  5,  5,  5,  5,  0,  3,  3,  3,  3,  3,  3,  3,  0,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  0,  0,  0,  3,  4,  0,  0
  },

  /* block 115 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  0,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  3,  3,  0,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 116 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0
  },

  /* block 117 */
  {  3,  3,  3,  0,  0,  0,  0,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  0,  0,  0,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 118 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,
     3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  2,  0,  0
  },

  /* block 119 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     2,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0
  },

  /* block 120 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  2,  2,  2,  2,  2,  0,  0,  0,  0,  0
  },

  /* block 121 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  0,  0,  0,  0,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 122 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  0,  0,  0,  0,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0
  },

  /* block 123 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 124 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 125 */
  {  3,  3,  3,  3,  3,  3,  0,  0,  3,  0,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  0,  3,  3,  0,  0,  0,  3,  0,  0,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  0,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 126 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,
     0,  0,  0,  0,  0,  0,  0,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  0,  3,  3,  0,  0,  0,  0,  0,  3,  3,  3,  3,  3
  },

  /* block 127 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  3,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 128 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     0,  0,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 129 */
  {  3,  2,  2,  2,  0,  2,  2,  0,  0,  0,  0,  0,  2,  2,  2,  2,
     3,  3,  3,  3,  0,  3,  3,  3,  0,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  0,  0,  0,  0,  2,  2,  2,  0,  0,  0,  0,  2,
     3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 130 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  2,  2,  0,  0,  0,  0,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 131 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  0,  0,  0,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  0,  0,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  0,  0,  0,  0,  0,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 132 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  0,  0,  0,  0,  0,  0,  0,  3,  3,  3,  3,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  3,  3,  3,  3,  3,  3,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 133 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 134 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  3,  3,  3,  3,  3,  3
  },

  /* block 135 */
  {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0
  },

  /* block 136 */
  {  3,  2,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  3,  3,  3,  3,  3,  3,  3,  0,  0,
     0,  0,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  2
  },

  /* block 137 */
  {  2,  2,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  2,  2,  2,  2,  3,  3,  2,  2,  3,  3,  2,  3,  3,
     3,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0
  },

  /* block 138 */
  {  2,  2,  2,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  2,  2,  2,  2,  2,  3,  2,  2,  2,
     2,  2,  2,  2,  2,  0,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  2,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 139 */
  {  2,  2,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  2,  2,  2,  3,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     0,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 140 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  0,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  2,
     2,  2,  3,  3,  2,  3,  2,  2,  3,  3,  3,  3,  3,  3,  2,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 141 */
  {  3,  3,  3,  3,  3,  3,  3,  0,  3,  0,  3,  3,  3,  3,  0,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  2,
     3,  3,  3,  2,  2,  2,  2,  2,  2,  2,  2,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0
  },

  /* block 142 */
  {  2,  2,  3,  3,  0,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  3,
     3,  0,  0,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  3,  3,  3,  3,  3,  3,
     3,  0,  3,  3,  0,  3,  3,  3,  3,  3,  0,  0,  2,  3,  3,  3,
     2,  3,  3,  3,  3,  0,  0,  3,  3,  0,  0,  3,  3,  3,  0,  0,
     3,  0,  0,  0,  0,  0,  0,  3,  0,  0,  0,  0,  0,  3,  3,  3,
     3,  3,  3,  3,  0,  0,  2,  2,  2,  2,  2,  2,  2,  0,  0,  0,
     2,  2,  2,  2,  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 143 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  2,  2,  2,  2,  2,  2,  2,  2,
     3,  3,  2,  2,  2,  3,  2,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  3,  0,  3,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 144 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  2,  2,  2,  2,  2,  2,  3,  2,  3,  3,  3,  3,  2,
     2,  3,  2,  2,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 145 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  2,  2,  2,  2,  0,  0,  3,  3,  3,  3,  2,  2,  3,  2,
     2,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  2,  2,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 146 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  2,  2,  2,  2,  2,  2,  2,  2,  3,  3,  2,  3,  2,
     2,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 147 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  2,  3,  2,  3,  3,
     2,  2,  2,  2,  2,  2,  3,  2,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 148 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  2,  2,  2,
     3,  3,  2,  2,  2,  2,  3,  2,  2,  2,  2,  2,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 149 */
  {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3
  },

  /* block 150 */
  {  3,  2,  2,  2,  2,  2,  2,  3,  3,  2,  2,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  2,  2,  2,  2,  2,  2,  3,  3,  2,  2,  2,  2,  3,
     3,  3,  3,  3,  3,  3,  3,  2,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  2,  2,  2,  2,  2,  2,  3,  3,  2,  2,  2,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 151 */
  {  3,  3,  3,  3,  0,  0,  3,  3,  3,  3,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  3,  2,  2,  3,  3,  3,  0,  3,  3,
     3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 152 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     2,  2,  2,  2,  2,  2,  2,  0,  2,  2,  2,  2,  2,  2,  3,  2,
     3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 153 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     0,  0,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  0,  3,  2,  2,  2,  2,  2,  2,
     2,  3,  2,  2,  3,  2,  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 154 */
  {  3,  3,  3,  3,  3,  3,  3,  0,  3,  3,  0,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  2,  2,  2,  2,  2,  2,  0,  0,  0,  2,  0,  2,  2,  0,  2,
     2,  2,  2,  2,  2,  2,  3,  2,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 155 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 156 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,
     3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 157 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 158 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 159 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 160 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  3,  3,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 161 */
  {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,
     2,  2,  2,  2,  2,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 162 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     2,  2,  2,  2,  2,  2,  2,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  3,  3,  3,  3,  3,
     3,  3,  0,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  3,  3,  3
  },

  /* block 163 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 164 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0
  },

  /* block 165 */
  {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  2,
     2,  2,  2,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     5,  5,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 166 */
  {  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 167 */
  {  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 168 */
  {  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5
  },

  /* block 169 */
  {  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  0,  0,  0,  0
  },

  /* block 170 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0
  },

  /* block 171 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  3,  2,  2,  3,
     1,  1,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 172 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 173 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  0,  0,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  2,  2,  2,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  1,  1,  1,  1,  1,  1,  1,  1,  2,  2,  2,  2,  2
  },

  /* block 174 */
  {  2,  2,  2,  3,  3,  2,  2,  2,  2,  2,  2,  2,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  2,  2,  2,  2,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 175 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  2,  2,  2,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 176 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 177 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  0,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 178 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  3,  3,
     0,  0,  3,  0,  0,  3,  3,  0,  0,  3,  3,  3,  3,  0,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  3,  0,  3,  3,  3,
     3,  3,  3,  3,  0,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 179 */
  {  3,  3,  3,  3,  3,  3,  0,  3,  3,  3,  3,  0,  0,  3,  3,  3,
     3,  3,  3,  3,  3,  0,  3,  3,  3,  3,  3,  3,  3,  0,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  3,  3,  3,  3,  0,
     3,  3,  3,  3,  3,  0,  3,  0,  0,  0,  3,  3,  3,  3,  3,  3,
     3,  0,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 180 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  0,  0,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 181 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 182 */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  3,  3,  3,  3,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  3,  3,  3,
     3,  3,  3,  3,  3,  2,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 183 */
  {  3,  3,  3,  3,  2,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  2,  2,  2,  2,  2,
     0,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 184 */
  {  2,  2,  2,  2,  2,  2,  2,  0,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  0,  0,  2,  2,  2,  2,  2,
     2,  2,  0,  2,  2,  0,  2,  2,  2,  2,  2,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 185 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  0,  0,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     2,  2,  2,  2,  2,  2,  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 186 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  2,  2,  2,  2,  2,  2,  2,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  3,  3,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 187 */
  {  3,  3,  3,  3,  0,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     0,  3,  3,  0,  3,  0,  0,  3,  0,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  0,  3,  3,  3,  3,  0,  3,  0,  3,  0,  0,  0,  0,
     0,  0,  3,  0,  0,  0,  0,  3,  0,  3,  0,  3,  0,  3,  3,  3,
     0,  3,  3,  0,  3,  0,  0,  3,  0,  3,  0,  3,  0,  3,  0,  3,
     0,  3,  3,  0,  3,  0,  0,  3,  3,  3,  3,  0,  3,  3,  3,  3,
     3,  3,  3,  0,  3,  3,  3,  3,  0,  3,  3,  3,  3,  0,  3,  0
  },

  /* block 188 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,
     0,  3,  3,  3,  0,  3,  3,  3,  3,  3,  0,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 189 */
  {  3,  3,  3,  3,  6,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 190 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,
     0,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     0,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  6,
     0,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 191 */
  {  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  3,  3,  0,  0,  0,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  3,  0,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  3,  3,  0,  0,  0,  0,
     6,  6,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  6,  6
  },

  /* block 192 */
  {  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  6,  4,
     4,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6
  },

  /* block 193 */
  {  5,  6,  6,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  6,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  6,
     5,  5,  6,  6,  6,  6,  6,  6,  6,  6,  6,  5,  0,  0,  0,  0,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  0,  0,  0,  0,  0,  0,  0,
     6,  6,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     5,  5,  5,  5,  5,  5,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 194 */
  {  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  3,  3,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6
  },

  /* block 195 */
  {  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  3,  3,  6,  6,  3,  6,  6,  6,  3,  3,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  3,  3,  6,  6,  6,  3,  6,  6,  6,  6,  6,  6,  6,  6,  6
  },

  /* block 196 */
  {  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6
  },

  /* block 197 */
  {  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  3,  6
  },

  /* block 198 */
  {  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  6,  6,  6,  6,  6,  6,  3,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  3,  3,  3,  3,  3,  3,  3,  6,
     6,  3,  3,  6,  6,  6,  6,  6,  6,  6,  6,  3,  3,  3,  3,  3
  },

  /* block 199 */
  {  3,  3,  3,  3,  3,  3,  3,  6,  3,  3,  6,  6,  6,  6,  3,  3,
     6,  3,  3,  3,  3,  6,  6,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  6,  6,  3,  3,  6,  3,  3,  3,  3,  3,  3,  3,
     3,  6,  6,  3,  3,  3,  3,  3,  3,  3,  3,  3,  6,  3,  3,  3,
     3,  3,  6,  6,  6,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  6,  6,  6,  3,  3,  3,  3,  3,  3,  3,  3,  6,  6,  6,  3,
     3,  6,  3,  6,  3,  3,  3,  3,  6,  3,  3,  3,  3,  3,  3,  6,
     3,  3,  3,  6,  3,  3,  3,  3,  3,  3,  6,  6,  6,  6,  6,  6
  },

  /* block 200 */
  {  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 201 */
  {  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  3,  3,  3,  3,  3,  6,  6,  6,  6,  6,
     6,  6,  6,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     6,  6,  6,  6,  6,  6,  3,  3,  3,  6,  3,  6,  6,  0,  0,  0,
     6,  3,  3,  6,  6,  6,  6,  6,  6,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 202 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 203 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 204 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3
  },

  /* block 205 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 206 */
  {  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0,  0,  0,  0,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  5,  6,  6,  6,  0,
     6,  6,  6,  6,  6,  6,  5,  6,  6,  6,  6,  6,  6,  0,  0,  0,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 207 */
  {  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     6,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 208 */
  {  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 209 */
  {  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5
  },

  /* block 210 */
  {  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  0,  0,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5
  },

  /* block 211 */
  {  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5
  },

  /* block 212 */
  {  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 213 */
  {  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  },

  /* block 214 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1
  }
};

static int charwidth(int32_t code)
{
	const int32_t block_size = 128;
	uint8_t i = charwidth_stage1[code / block_size];
	return charwidth_stage2[i][code % block_size];
}

#endif /* CHARWIDTH_H */
