% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{vis.kmer.histogram}
\alias{vis.kmer.histogram}
\title{Plot of the most frequent kmers.}
\usage{
vis.kmer.histogram(
  .kmers,
  .head = 100,
  .position = c("stack", "dodge", "fill")
)
}
\arguments{
\item{.kmers}{Data frame with two columns "Kmers" and "Count" or a list with such data frames. See Examples.}

\item{.head}{Number of the most frequent kmers to choose for plotting from each data frame.}

\item{.position}{Character vector of length 1. Position of bars for each kmers. Value for the \code{ggplot2} argument \code{position}.}
}
\description{
Plot a distribution (bar plot) of the most frequent kmers in a data.
}
\examples{
\dontrun{
# Load necessary data and package.
library(gridExtra)
load('immdata.rda')
# Get 5-mers.
imm.km <- get.kmers(immdata)
# Plots for kmer proportions in each data frame in immdata.
p1 <- vis.kmer.histogran(imm.km, .position = 'stack')
p2 <- vis.kmer.histogran(imm.km, .position = 'fill')
grid.arrange(p1, p2)
}
}
\seealso{
\code{get.kmers}
}
