% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infoanalysis.R
\name{entropy.seg}
\alias{entropy.seg}
\alias{js.div.seg}
\title{Repertoires' analysis using information measures applied to V- and J- segment frequencies.}
\usage{
entropy.seg(.data, .genes = HUMAN_TRBV, .frame = c('all', 'in', 'out'),
            .quant = c(NA, "read.count", "umi.count", "read.prop", "umi.prop"),
            .ambig = F)

js.div.seg(.data, .genes = HUMAN_TRBV, .frame = c('all', 'in', 'out'),
           .quant = c(NA, "read.count", "umi.count", "read.prop", "umi.prop"),
           .norm.entropy = T, .ambig = F, .verbose = F, .data2 = NULL)
}
\arguments{
\item{.data}{Mitcr data.frame or a list with mitcr data.frames.}

\item{.genes}{Parameter to the \code{geneUsage} function.}

\item{.frame}{Character vector of length 1 specified which *-frames should be used:
only in-frame ('in'), out-of-frame ('out') or all sequences ('all').}

\item{.quant}{Which column to use for the quantity of clonotypes: NA for computing only number of genes without using clonotype counts, "read.count" for the "Read.count" column, 
"umi.count" for the "Umi.count" column, "read.prop" for the "Read.proportion" column, "umi.prop" for 
the "Umi.proportion" column.}

\item{.ambig}{Parameter passed to \code{geneUsage}.}

\item{.data2}{NULL if .data is a list, or a second mitcr data.frame.}

\item{.norm.entropy}{if T then divide result by mean entropy of 2 segments' frequencies.}

\item{.verbose}{If T than output the data processing progress bar.}
}
\value{
For \code{entropy.seg} - numeric integer with entropy value(s). For \code{js.div.seg} - integer of vector one if \code{.data} and \code{.data2} are provided;
esle matrix length(.data) X length(.data) if \code{.data} is a list.
}
\description{
Information approach to repertoire analysis. Function \code{entropy.seg} applies Shannon entropy to V-usage and hence measures variability of V-usage.
Function \code{js.div.seg} applied Jensen-Shannon divergence to V-usage of two or more data frames and hence measures distance among this V-usages.
}
\seealso{
\link{vis.heatmap}, \link{vis.group.boxplot}, \link{geneUsage}
}
