% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gna_search.R
\name{gna_search}
\alias{gna_search}
\title{Search for taxonomic names using the Global Names Architecture}
\usage{
gna_search(sci, justtotal = FALSE, parse_names = FALSE, ...)
}
\arguments{
\item{sci}{(character) required. Name pattern you want to search
for. WARNING: Does not work for common names. Search term may include
following options:
\itemize{
\item \code{n}: A shortcut that allows to put together several elements (e.g., \verb{n:B. bubo Linn. 1750-1800})
\item \code{g}: a genus name. (e.g. \code{g:B.}, \code{g:Bub.}, \code{g:Bubo})
\item \code{isp}: an infraspecies name (e.g. \code{sp:bubo}, \code{sp:gallop.})
\item \code{asp}: either species or infraspecies (all sp) (e.g. \code{asp:bubo})
\item \code{ds}: data-sources IDs (e.g., \verb{ds:1,2,3})
\item \code{tx}: parent taxon . Uses classification of the first data-source from \code{ds}. If data-sources are not set, uses Catalogue of Life. (e.g. \code{tx:Aves})
\item \code{au}: author - Search by author word    (e.g. \code{au:Linnaeus}, \code{au:Linn.})
\item \code{y}: year - Search by year (e.g. \code{y:2005})
}}

\item{justtotal}{Return only the total results found.}

\item{parse_names}{If \code{TRUE} use \code{\link[=gni_parse]{gni_parse()}} on the outputs.}

\item{...}{Curl options passed on to \link[crul:verb-GET]{crul::verb-GET}}
}
\value{
data.frame of results.
}
\description{
Uses the Global Names Index, see http://gni.globalnames.org
}
\examples{
\dontrun{
gna_search('n:B. bubo ds:1,2 au:Linn. y:1700-')
}
}
\references{
http://gni.globalnames.org/
https://apidoc.globalnames.org/gnames
}
\seealso{
\code{\link[=gnr_datasources]{gnr_datasources()}}, \code{\link[=gna_search]{gna_search()}}
}
\author{
Scott Chamberlain, Zachary Foster
}
\keyword{globalnamesindex}
\keyword{names}
\keyword{taxonomy}
