% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimreduc.R
\docType{class}
\name{DimReduc-class}
\alias{DimReduc-class}
\alias{DimReduc}
\title{The Dimensional Reduction Class}
\description{
The DimReduc object stores a dimensionality reduction taken out in Seurat;
each DimReduc consists of a cell embeddings matrix, a feature loadings
matrix, and a projected feature loadings matrix.
}
\section{Slots}{

\describe{
\item{\code{cell.embeddings}}{Cell embeddings matrix (required)}

\item{\code{feature.loadings}}{Feature loadings matrix (optional)}

\item{\code{feature.loadings.projected}}{Projected feature loadings matrix (optional)}

\item{\code{assay.used}}{Name of assay used to generate \code{DimReduc} object}

\item{\code{global}}{Is this \code{DimReduc} global/persistent? If so, it will not be
removed when removing its associated assay}

\item{\code{stdev}}{A vector of standard deviations}

\item{\code{jackstraw}}{A \code{\link{JackStrawData-class}} object associated with
this \code{DimReduc}}

\item{\code{misc}}{A named list of unstructured miscellaneous data}

\item{\code{key}}{A one-length character vector with the object's key; keys must
be one or more alphanumeric characters followed by an underscore
\dQuote{\code{_}} (regex pattern
\dQuote{\code{\Sexpr[stage=build]{SeuratObject:::.KeyPattern()}}})}
}}

\seealso{
Dimensional reduction object, validity, and interaction methods
\code{\link{CreateDimReducObject}()},
\code{\link{DimReduc-validity}},
\code{\link{[.DimReduc}()},
\code{\link{[[.DimReduc}()},
\code{\link{dim.DimReduc}()},
\code{\link{merge.DimReduc}()},
\code{\link{print.DimReduc}()},
\code{\link{subset.DimReduc}()}
}
\concept{dimreduc}
