% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seurat.R
\name{names.Seurat}
\alias{names.Seurat}
\title{Subobject Names}
\usage{
\method{names}{Seurat}(x)
}
\arguments{
\item{x}{A \code{\link{Seurat}} object}
}
\value{
The names of all of the following subobjects within \code{x}:
\itemize{
 \item \link[=Assay]{v3} and \link[=Assay5]{v5} assays
 \item \link[=DimReduc]{dimensional reductions}
 \item \link[=SpatialImage]{images} and \link[=FOV]{FOVs}
 \item \link[=Graph]{nearest-neighbor graphs}
}
}
\description{
Get the names of subobjects within a \code{\link{Seurat}} object
}
\examples{
names(pbmc_small)

}
\seealso{
Seurat object, validity, and interaction methods
\code{\link{$.Seurat}()},
\code{\link{Seurat-class}},
\code{\link{Seurat-validity}},
\code{\link{[[.Seurat}()},
\code{\link{[[<-,Seurat,NULL}},
\code{\link{[[<-,Seurat}},
\code{\link{dim.Seurat}()},
\code{\link{dimnames.Seurat}()},
\code{\link{merge.Seurat}()},
\code{\link{subset.Seurat}()}
}
\concept{seurat}
