% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimreduc.R
\name{[.DimReduc}
\alias{[.DimReduc}
\title{Get Feature Loadings}
\usage{
\method{[}{DimReduc}(x, i, j, drop = FALSE, ...)
}
\arguments{
\item{x}{A \code{\link{DimReduc}} object}

\item{i}{Feature identifiers or indices}

\item{j}{Dimension identifiers or indices}

\item{drop}{Coerce the result to the lowest possible dimension; see
\code{\link{drop}} for further details}

\item{...}{Arguments passed to other methods}
}
\value{
Feature loadings for features \code{i} and dimensions \code{j}
}
\description{
Pull feature loadings from a \link[=DimReduc]{dimensional reduction}
}
\details{
\code{[} does not distinguish between projected and unprojected feature
loadings; to select whether projected or unprojected loadings should be
pulled, please use \code{\link{Loadings}}
}
\examples{
pca <- pbmc_small[["pca"]]
pca[1:10, 1:5]

}
\seealso{
\code{\link{Loadings}}

Dimensional reduction object, validity, and interaction methods
\code{\link{CreateDimReducObject}()},
\code{\link{DimReduc-class}},
\code{\link{DimReduc-validity}},
\code{\link{[[.DimReduc}()},
\code{\link{dim.DimReduc}()},
\code{\link{merge.DimReduc}()},
\code{\link{print.DimReduc}()},
\code{\link{subset.DimReduc}()}
}
\concept{dimreduc}
