% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{ExportToCellbrowser}
\alias{ExportToCellbrowser}
\title{Export Seurat object for UCSC cell browser}
\usage{
ExportToCellbrowser(
  object,
  dir,
  dataset.name = Project(object = object),
  reductions = "tsne",
  markers.file = NULL,
  cluster.field = "Cluster",
  cb.dir = NULL,
  port = NULL,
  skip.expr.matrix = FALSE,
  skip.metadata = FALSE,
  skip.reductions = FALSE,
  ...
)
}
\arguments{
\item{object}{Seurat object}

\item{dir}{path to directory where to save exported files. These are:
exprMatrix.tsv, tsne.coords.tsv, meta.tsv, markers.tsv and a default cellbrowser.conf}

\item{dataset.name}{name of the dataset. Defaults to Seurat project name}

\item{reductions}{vector of reduction names to export}

\item{markers.file}{path to file with marker genes}

\item{cluster.field}{name of the metadata field containing cell cluster}

\item{cb.dir}{path to directory where to create UCSC cellbrowser static
website content root, e.g. an index.html, .json files, etc. These files
can be copied to any webserver. If this is specified, the cellbrowser
package has to be accessible from R via reticulate.}

\item{port}{on which port to run UCSC cellbrowser webserver after export}

\item{skip.expr.matrix}{whether to skip exporting expression matrix}

\item{skip.metadata}{whether to skip exporting metadata}

\item{skip.reductions}{whether to skip exporting reductions}

\item{...}{specifies the metadata fields to export. To supply field with
human readable name, pass name as \code{field="name"} parameter.}
}
\value{
This function exports Seurat object as a set of tsv files
to \code{dir} directory, copying the \code{markers.file} if it is
passed. It also creates the default \code{cellbrowser.conf} in the
directory. This directory could be read by \code{cbBuild} to
create a static website viewer for the dataset. If \code{cb.dir}
parameter is passed, the function runs \code{cbBuild} (if it is
installed) to create this static website in \code{cb.dir} directory.
If \code{port} parameter is passed, it also runs the webserver for
that directory and opens a browser.
}
\description{
Export Seurat object for UCSC cell browser
}
\examples{
\dontrun{
ExportToCellbrowser(object = pbmc_small, dataset.name = "PBMC", dir = "out")
}

}
\author{
Maximilian Haeussler, Nikolay Markov
}
