% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pal-brewer.R
\name{pal_brewer}
\alias{pal_brewer}
\alias{brewer_pal}
\title{Colour Brewer palette (discrete)}
\usage{
pal_brewer(type = "seq", palette = 1, direction = 1)

brewer_pal(type = "seq", palette = 1, direction = 1)
}
\arguments{
\item{type}{One of "seq" (sequential), "div" (diverging) or "qual"
(qualitative)}

\item{palette}{If a string, will use that named palette. If a number, will
index into the list of palettes of appropriate \code{type}}

\item{direction}{Sets the order of colours in the scale. If 1, the default,
colours are as output by \code{\link[RColorBrewer:ColorBrewer]{RColorBrewer::brewer.pal()}}. If -1, the
order of colours is reversed.}
}
\description{
Colour Brewer palette (discrete)
}
\examples{
show_col(pal_brewer()(10))
show_col(pal_brewer("div")(5))
show_col(pal_brewer(palette = "Greens")(5))

# Can use with gradient_n to create a continuous gradient
cols <- pal_brewer("div")(5)
show_col(pal_gradient_n(cols)(seq(0, 1, length.out = 30)))
}
\references{
\url{https://colorbrewer2.org}
}
