% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_analysis_base.R
\name{getConditionalRejectionProbabilities}
\alias{getConditionalRejectionProbabilities}
\title{Get Conditional Rejection Probabilities}
\usage{
getConditionalRejectionProbabilities(design, stageResults, ...)
}
\arguments{
\item{design}{The trial design.}

\item{stageResults}{The results at given stage, obtained from \code{\link{getStageResults}}.}

\item{stage}{The stage number (optional). Default: total number of existing stages in the data input.}
}
\description{
Calculates the conditional rejection probabilities (CRP) for given test results.
}
\details{
The conditional rejection probability is the probability, under H0, to reject H0 
in one of the subsequent (remaining) stages.
The probability is calculated using the specified design. For testing rates and the 
survival design, the normal approximation is used, i.e., it is calculated with the 
use of the prototype case testing a mean for normally distributed data with known variance.

The conditional rejection probabilities are provided up to the specified stage.

For Fisher's combination test, you can check the validity of the CRP calculation via simulation.
}
\examples{

x <- getDesignFisher(kMax = 3, informationRates = c(0.1,0.8,1))
y <- getDataset(n = c(40,40), events = c(20,22))
getConditionalRejectionProbabilities(x, getStageResults(x, y, thetaH0 = 0.4))
# provides 
# [1] 0.0216417 0.1068607        NA

}
\keyword{internal}
