% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_time.R
\name{getAccrualTime}
\alias{getAccrualTime}
\title{Get Accrual Time}
\usage{
getAccrualTime(
  accrualTime = NA_real_,
  ...,
  accrualIntensity = NA_real_,
  maxNumberOfSubjects = NA_real_
)
}
\arguments{
\item{accrualTime}{The assumed accrual time for the study, default is \code{c(0,12)} (see details).}

\item{...}{Ensures that all arguments after \code{accrualTime} are be named and 
that a warning will be displayed if unknown arguments are passed.}

\item{accrualIntensity}{A vector of accrual intensities, default is the relative 
intensity \code{0.1} (see details).}

\item{maxNumberOfSubjects}{The maximum number of subjects.}
}
\value{
Returns a \code{\link{AccrualTime}} object.
}
\description{
Returns a \code{AccrualTime} object that contains the accrual time and the accrual intensity.
}
\details{
\code{accrualTime} can also be used to define a non-constant accrual over time. 
For this, \code{accrualTime} needs to be a vector that defines the accrual intervals and
\code{accrualIntensity} needs to be specified. The first element of \code{accrualTime} must be equal to 0.\cr 
\code{accrualTime} can also be a list that combines the definition of the accrual time and 
accrual intensity \code{accrualIntensity} (see below and examples for details). 
If the length of \code{accrualTime} and the length of \code{accrualIntensity} are 
the same (i.e., the end of accrual is undefined), \code{maxNumberOfPatients > 0} needs to 
be specified and the end of accrual is calculated.	

\code{accrualIntensity} needs to be defined if a vector of \code{accrualTime} is specified.\cr
If the length of \code{accrualTime} and the length of \code{accrualIntensity} are the same 
(i.e., the end of accrual is undefined), \code{maxNumberOfPatients > 0} needs to be specified 
and the end of accrual is calculated.	
In that case, \code{accrualIntensity} is given by the number of subjects per time unit.\cr
If the length of \code{accrualTime} equals the length of \code{accrualIntensity - 1}   
(i.e., the end of accrual is defined), \code{maxNumberOfPatients} is calculated. 
In that case, \code{accrualIntensity} defines the intensity how subjects enter the trial. 
For example, \code{accrualIntensity = c(1,2)} specifies that in the second accrual interval 
the intensity is doubled as compared to the first accrual interval. The actual accrual intensity 
is calculated for the calculated  \code{maxNumberOfPatients}.
}
\examples{

\donttest{ 

# Case 1

# > End of accrual, absolute accrual intensity and `maxNumberOfSubjects` are given, 
# > `followUpTime`** shall be calculated. 

## Example: vector based definition

accrualTime <- getAccrualTime(accrualTime = c(0, 6, 30), 
    accrualIntensity = c(22, 33), maxNumberOfSubjects = 924) 
accrualTime


## Example: list based definition

accrualTime <- getAccrualTime(list(
    "0 - <6"   = 22,
    "6 - <=30" = 33), 
    maxNumberOfSubjects = 924) 
accrualTime


## Example: how to use accrual time object

getSampleSizeSurvival(accrualTime = accrualTime, pi1 = 0.4, pi2 = 0.2)


# Case 2

# > End of accrual, relative accrual intensity and `maxNumberOfSubjects` are given, 
# > absolute accrual intensity* and `followUpTime`** shall be calculated. 

## Example: vector based definition 

accrualTime <- getAccrualTime(accrualTime = c(0, 6, 30), 
    accrualIntensity = c(0.22, 0.33), maxNumberOfSubjects = 1000) 
accrualTime


## Example: list based definition

accrualTime <- getAccrualTime(list(
    "0 - <6"   = 0.22,
    "6 - <=30" = 0.33), 
    maxNumberOfSubjects = 1000) 
accrualTime


## Example: how to use accrual time object

getSampleSizeSurvival(accrualTime = accrualTime, pi1 = 0.4, pi2 = 0.2)


# Case 3

# > End of accrual and absolute accrual intensity are given, 
# > `maxNumberOfSubjects`* and `followUpTime`** shall be calculated. 

## Example: vector based definition 

accrualTime <- getAccrualTime(accrualTime = c(0, 6, 30), accrualIntensity = c(22, 33)) 


## Example: list based definition

accrualTime <- getAccrualTime(list(
    "0 - <6"   = 22,
    "6 - <=30" = 33)) 
accrualTime


## Example: how to use accrual time object

getSampleSizeSurvival(accrualTime = accrualTime, pi1 = 0.4, pi2 = 0.2)


# Case 4

# > End of accrual, relative accrual intensity and `followUpTime` are given, 
# > absolute accrual intensity** and `maxNumberOfSubjects`** shall be calculated. 

## Example: vector based definition 

accrualTime <- getAccrualTime(accrualTime = c(0, 6, 30), accrualIntensity = c(0.22, 0.33)) 
accrualTime


## Example: list based definition

accrualTime <- getAccrualTime(list(
    "0 - <6"   = 0.22,
    "6 - <=30" = 0.33)) 
accrualTime


## Example: how to use accrual time object

getSampleSizeSurvival(accrualTime = accrualTime, pi1 = 0.4, pi2 = 0.2)


# Case 5

# > `maxNumberOfSubjects` and absolute accrual intensity are given, 
# > absolute accrual intensity*, end of accrual* and `followUpTime`** shall be calculated 

## Example: vector based definition 

accrualTime <- getAccrualTime(accrualTime = c(0, 6), 
    accrualIntensity = c(22, 33), maxNumberOfSubjects = 1000) 
accrualTime


## Example: list based definition

accrualTime <- getAccrualTime(list(
    "0 - <6" = 22,
    "6"      = 33), 
    maxNumberOfSubjects = 1000) 
accrualTime


## Example: how to use accrual time object

getSampleSizeSurvival(accrualTime = accrualTime, pi1 = 0.4, pi2 = 0.2)


# Case 6 (not possible)

# > `maxNumberOfSubjects` and relative accrual intensity are given, 
# > absolute accrual intensity[x], end of accrual* and `followUpTime`** shall be calculated 

## Example: vector based definition 

accrualTime <- getAccrualTime(accrualTime = c(0, 6), 
    accrualIntensity = c(0.22, 0.33), maxNumberOfSubjects = 1000) 
accrualTime


## Example: list based definition

accrualTime <- getAccrualTime(list(
    "0 - <6" = 0.22,
    "6"      = 0.33), 
    maxNumberOfSubjects = 1000) 
accrualTime


## Example: how to use accrual time object

# Case 6 is not allowed and therefore an error will be shown:

tryCatch({	
    getSampleSizeSurvival(accrualTime = accrualTime, pi1 = 0.4, pi2 = 0.2)
}, error = function(e) {
    print(e$message)
})


# Case 7

# > `followUpTime` and absolute accrual intensity are given,  
# > end of accrual** and `maxNumberOfSubjects`** shall be calculated 

## Example: vector based definition 

accrualTime <- getAccrualTime(accrualTime = c(0, 6), accrualIntensity = c(22, 33)) 
accrualTime


## Example: list based definition

accrualTime <- getAccrualTime(list(
    "0 - <6" = 22,
    "6"      = 33)) 
accrualTime


## Example: how to use accrual time object

getSampleSizeSurvival(accrualTime = accrualTime, 
    pi1 = 0.4, pi2 = 0.2, followUpTime = 6)


# Case 8 (not possible)

# > `followUpTime` and relative accrual intensity are given,  
# > absolute accrual intensity[x], end of accrual and `maxNumberOfSubjects` shall be calculated 

## Example: vector based definition 

accrualTime <- getAccrualTime(accrualTime = c(0, 6), accrualIntensity = c(0.22, 0.33)) 
accrualTime


## Example: list based definition

accrualTime <- getAccrualTime(list(
    "0 - <6" = 0.22,
    "6"      = 0.33)) 
accrualTime


## Example: how to use accrual time object

# Case 8 is not allowed and therefore an error will be shown:

tryCatch({	
    getSampleSizeSurvival(accrualTime = accrualTime, pi1 = 0.4, pi2 = 0.2, followUpTime = 6)
}, error = function(e) {
    print(e$message)
})


# How to show accrual time details

# You can use a sample size or power object as argument for function `getAccrualTime`:

sampleSize <- getSampleSizeSurvival(accrualTime = c(0, 6), accrualIntensity = c(22, 53), 
    lambda2 = 0.05, hazardRatio = 0.8, followUpTime = 6)
sampleSize
accrualTime <- getAccrualTime(sampleSize)
accrualTime

}

}
