% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all.R
\name{re_match_all}
\alias{re_match_all}
\title{Extract All Regular Expression Matches Into a Data Frame}
\usage{
re_match_all(text, pattern, perl = TRUE, ...)
}
\arguments{
\item{text}{Character vector.}

\item{pattern}{A regular expression. See \code{\link[base]{regex}} for more
about regular expressions.}

\item{perl}{logical should perl compatible regular expressions be used?
Defaults to TRUE, setting to FALSE will disable capture groups.}

\item{...}{Additional arguments to pass to
\code{\link[base]{gregexpr}} (or \code{\link[base]{regexpr}} if
\code{text} is of length zero).}
}
\value{
A tidy data frame (see Section \dQuote{Tidy Data}).  The list columns
  contain character vectors with as many entries as there are matches for
  each input element.
}
\description{
This function is a thin wrapper on the \code{\link[base]{gregexpr}}
base R function, to extract the matching (sub)strings as a data frame.
It extracts all matches, and potentially their capture groups as well.
}
\note{
If the input text character vector has length zero,
  \code{\link[base]{regexpr}} is called instead of
  \code{\link[base]{gregexpr}}, because the latter cannot extract the
  number and names of the capture groups in this case.
}
\section{Tidy Data}{


The return value is a tidy data frame where each row
corresponds to an element of the input character vector \code{text}.  The
values from \code{text} appear for reference in the \code{.text} character
column.  All other columns are list columns containing the match data.  The
\code{.match} column contains the match information for full regular
expression matches while other columns correspond to capture groups if there
are any, and PCRE matches are enabled with \code{perl = TRUE} (this is on by
default).  If capture groups are named the corresponding columns will bear
those names.

Each match data column list contains match records, one for each element in
\code{text}.  A match record is a named list, with entries \code{match},
\code{start} and \code{end} that are respectively the matching (sub) string,
the start, and the end positions (using one based indexing).
}

\examples{
name_rex <- paste0(
  "(?<first>[[:upper:]][[:lower:]]+) ",
  "(?<last>[[:upper:]][[:lower:]]+)"
)
notables <- c(
  "  Ben Franklin and Jefferson Davis",
  "\tMillard Fillmore"
)
re_match_all(notables, name_rex)
}
\seealso{
Other tidy regular expression matching: 
\code{\link{re_exec_all}()},
\code{\link{re_exec}()},
\code{\link{re_match}()}
}
\concept{tidy regular expression matching}
