% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parseTOML.R
\name{parseTOML}
\alias{parseTOML}
\alias{tomlparse}
\alias{parseToml}
\alias{print.toml}
\alias{summary.toml}
\title{Parse a TOML file}
\usage{
parseTOML(input, verbose = FALSE, fromFile = TRUE, includize = FALSE,
  escape = TRUE)

tomlparse(...)

parseToml(...)

\method{print}{toml}(x, ...)

\method{summary}{toml}(object, ...)
}
\arguments{
\item{input}{[character] TOML input, either as chracter value or path to TOML file}

\item{verbose}{[logical] Optional verbosity flag, no current effect}

\item{fromFile}{[logical] Optional with default value \sQuote{TRUE} indicating parsing from file}

\item{includize}{[logical] Optional legacy option, no current effect}

\item{escape}{[logical] Optional boolean whether strings should be escaped, defaults to
\sQuote{TRUE}}

\item{...}{Used for aliased function and S3 methods}

\item{x}{Used for S3 method}

\item{object}{Used for S3 method}
}
\value{
A list object with the parsed content as an S3 object of class \sQuote{toml}
}
\description{
The function \code{parseTOML}, also aliased to \code{tomlparse} and \code{parseToml},
parse TOML content inout. This is usually a file given by its name, or a character variable
with a TOML expression.
}
\details{
This implementation uses the \sQuote{tomlplusplus} library by Mark Gillar (see
\url{https://github.com/marzer/tomlplusplus}) which is TOML 1.0 compliant. In earlier
work the package used the \sQuote{cpptoml} library by Chase Geigle (see
\url{https://github.com/skystrife/cpptoml} for which development ceased once TOML 0.5.0
parity was reached.
}
