% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify-tree.R
\name{modify_tree}
\alias{modify_tree}
\title{Recursively modify a list}
\usage{
modify_tree(
  x,
  ...,
  leaf = identity,
  is_node = NULL,
  pre = identity,
  post = identity
)
}
\arguments{
\item{x}{A list.}

\item{...}{Reserved for future use. Must be empty}

\item{leaf}{A function applied to each leaf.}

\item{is_node}{A predicate function that determines whether an element is
a node (by returning \code{TRUE}) or a leaf (by returning \code{FALSE}). The
default value, \code{NULL}, treats simple lists as nodes and everything else
(including richer objects like data frames and linear models) as leaves,
using \code{\link[vctrs:vec_is_list]{vctrs::vec_is_list()}}. To recurse into all objects built on lists
use \code{\link[=is.list]{is.list()}}.}

\item{pre, post}{Functions applied to each node. \code{pre} is applied on the
way "down", i.e. before the leaves are transformed with \code{leaf}, while
\code{post} is applied on the way "up", i.e. after the leaves are transformed.}
}
\description{
\code{modify_tree()} allows you to recursively modify a list, supplying functions
that either modify each leaf or each node (or both).
}
\examples{
x <- list(list(a = 2:1, c = list(b1 = 2), b = list(c2 = 3, c1 = 4)))
x |> str()

# Transform each leaf
x |> modify_tree(leaf = \(x) x + 100) |>  str()

# Recursively sort the nodes
sort_named <- function(x) {
  nms <- names(x)
  if (!is.null(nms)) {
    x[order(nms)]
  } else {
    x
   }
}
x |> modify_tree(post = sort_named) |> str()
}
\seealso{
Other modify variants: 
\code{\link{map_depth}()},
\code{\link{modify}()}
}
\concept{modify variants}
