% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_draws.R
\name{subset_draws}
\alias{subset_draws}
\alias{subset_draws.draws_matrix}
\alias{subset_draws.draws_array}
\alias{subset_draws.draws_df}
\alias{subset_draws.draws_list}
\alias{subset_draws.draws_rvars}
\alias{subset_draws.rvar}
\alias{subset.draws}
\title{Subset \code{draws} objects}
\usage{
subset_draws(x, ...)

\method{subset_draws}{draws_matrix}(
  x,
  variable = NULL,
  iteration = NULL,
  chain = NULL,
  draw = NULL,
  regex = FALSE,
  unique = TRUE,
  ...
)

\method{subset_draws}{draws_array}(
  x,
  variable = NULL,
  iteration = NULL,
  chain = NULL,
  draw = NULL,
  regex = FALSE,
  unique = TRUE,
  ...
)

\method{subset_draws}{draws_df}(
  x,
  variable = NULL,
  iteration = NULL,
  chain = NULL,
  draw = NULL,
  regex = FALSE,
  unique = TRUE,
  ...
)

\method{subset_draws}{draws_list}(
  x,
  variable = NULL,
  iteration = NULL,
  chain = NULL,
  draw = NULL,
  regex = FALSE,
  unique = TRUE,
  ...
)

\method{subset_draws}{draws_rvars}(
  x,
  variable = NULL,
  iteration = NULL,
  chain = NULL,
  draw = NULL,
  regex = FALSE,
  unique = TRUE,
  ...
)

\method{subset_draws}{rvar}(x, variable = NULL, ...)

\method{subset}{draws}(x, ...)
}
\arguments{
\item{x}{(draws) A \code{draws} object or another \R object for which the method
is defined.}

\item{...}{Arguments passed to individual methods (if applicable).}

\item{variable}{(character vector) The variables to select. All elements of
non-scalar variables can be selected at once.}

\item{iteration}{(integer vector) The iteration indices to select.}

\item{chain}{(integer vector) The chain indices to select.}

\item{draw}{(integer vector) The draw indices to be select. Subsetting draw
indices will lead to an automatic merging of chains via \code{\link{merge_chains}}.}

\item{regex}{(logical) Should \code{variable} should be treated as a
(vector of) regular expressions? Any variable in \code{x} matching at least one
of the regular expressions will be selected. Defaults to \code{FALSE}.}

\item{unique}{(logical) Should duplicated selection of chains, iterations, or
draws be allowed? If \code{TRUE} (the default) only unique chains, iterations,
and draws are selected regardless of how often they appear in the
respective selecting arguments.}
}
\value{
A \code{draws} object of the same class as \code{x}.
}
\description{
Subset \code{\link{draws}} objects by variables, iterations, chains, and draws indices.
}
\details{
To ensure that multiple consecutive subsetting operations work correctly,
\code{subset()} \emph{\link[=repair_draws]{repairs}} the \code{draws} object before and after
subsetting.
}
\examples{
x <- example_draws()
subset_draws(x, variable = c("mu", "tau"))
subset_draws(x, chain = 2)
subset_draws(x, iteration = 5:10, chain = 3:4)

# extract the first chain twice
subset_draws(x, chain = c(1, 1), unique = FALSE)

# extract all elements of 'theta'
subset_draws(x, variable = "theta")

}
