% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/order_draws.R
\name{order_draws}
\alias{order_draws}
\alias{order_draws.draws_matrix}
\alias{order_draws.draws_array}
\alias{order_draws.draws_df}
\alias{order_draws.draws_list}
\alias{order_draws.draws_rvars}
\alias{order_draws.rvar}
\title{Order \code{draws} objects}
\usage{
order_draws(x, ...)

\method{order_draws}{draws_matrix}(x, ...)

\method{order_draws}{draws_array}(x, ...)

\method{order_draws}{draws_df}(x, ...)

\method{order_draws}{draws_list}(x, ...)

\method{order_draws}{draws_rvars}(x, ...)

\method{order_draws}{rvar}(x, ...)
}
\arguments{
\item{x}{(draws) A \code{draws} object or another \R object for which the method
is defined.}

\item{...}{Arguments passed to individual methods (if applicable).}
}
\value{
A \code{draws} object of the same class as \code{x}.
}
\description{
Order \code{\link{draws}} objects according to iteration and chain number. By default,
draws objects are ordered but subsetting or extracting parts of them may
leave them in an unordered state.
}
\examples{
x <- as_draws_array(example_draws())
dimnames(x[10:5, 4:3, ])
dimnames(order_draws(x[10:5, 4:3, ]))

}
\seealso{
\code{\link[=repair_draws]{repair_draws()}}
}
