% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_draws_list.R
\name{draws_list}
\alias{draws_list}
\alias{as_draws_list}
\alias{as_draws_list.default}
\alias{as_draws_list.draws_list}
\alias{as_draws_list.draws_matrix}
\alias{as_draws_list.draws_array}
\alias{as_draws_list.draws_df}
\alias{as_draws_list.draws_rvars}
\alias{as_draws_list.mcmc}
\alias{as_draws_list.mcmc.list}
\alias{is_draws_list}
\title{The \code{draws_list} format}
\usage{
as_draws_list(x, ...)

\method{as_draws_list}{default}(x, ...)

\method{as_draws_list}{draws_list}(x, ...)

\method{as_draws_list}{draws_matrix}(x, ...)

\method{as_draws_list}{draws_array}(x, ...)

\method{as_draws_list}{draws_df}(x, ...)

\method{as_draws_list}{draws_rvars}(x, ...)

\method{as_draws_list}{mcmc}(x, ...)

\method{as_draws_list}{mcmc.list}(x, ...)

draws_list(..., .nchains = 1)

is_draws_list(x)
}
\arguments{
\item{x}{An object to convert to a \code{draws_list} object.}

\item{...}{For \code{as_draws_list()}:
Arguments passed to individual methods (if applicable).
For \code{draws_list()}: Named
arguments containing numeric vectors each defining a separate variable.}

\item{.nchains}{(positive integer) The number of chains. The default is \code{1}.}
}
\value{
A \code{draws_list} object, which has classes
\code{c("draws_list", "draws", "list")}.
}
\description{
The \code{as_draws_list()} methods convert
objects to the \code{draws_list} format.
The \code{draws_list()} function creates an object of the
\code{draws_list} format based on a set of numeric vectors.
See \strong{Details}.
}
\details{
Objects of class \code{"draws_list"} are lists with one element per MCMC
chain. Each of these elements is itself a named list of numeric vectors
with one vector per variable. The length of each vector is equal to the
number of saved iterations per chain. See \strong{Examples}.
}
\examples{
x1 <- as_draws_list(example_draws())
class(x1)
print(x1)
str(x1)

x2 <- draws_list(a = rnorm(10), b = rnorm(10), c = 1)
class(x2)
print(x2)
str(x2)
}
\seealso{
Other formats: 
\code{\link{draws_array}()},
\code{\link{draws_df}()},
\code{\link{draws_matrix}()},
\code{\link{draws_rvars}()},
\code{\link{draws}}
}
\concept{formats}
