% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pr.R
\name{pr_filter}
\alias{pr_filter}
\title{Add a filter to Plumber router}
\usage{
pr_filter(pr, name, expr, serializer)
}
\arguments{
\item{pr}{A Plumber API. Note: The supplied Plumber API object will also be updated in place as well as returned by the function.}

\item{name}{A character string. Name of filter}

\item{expr}{An expr that resolve to a filter function or a filter function}

\item{serializer}{A serializer function}
}
\value{
The Plumber router with the defined filter added
}
\description{
Filters can be used to modify an incoming request, return an error, or return
a response prior to the request reaching an endpoint.
}
\examples{
\dontrun{
pr() \%>\%
  pr_filter("foo", function(req, res) {
    print("This is filter foo")
    forward()
  }) \%>\%
  pr_get("/hi", function() "Hello") \%>\%
  pr_run()
}

}
