% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_gmm.R
\name{mtest}
\alias{mtest}
\alias{mtest.pgmm}
\title{Arellano--Bond Test of Serial Correlation}
\usage{
mtest(object, ...)

\method{mtest}{pgmm}(object, order = 1L, vcov = NULL, ...)
}
\arguments{
\item{object}{an object of class \code{"pgmm"},}

\item{\dots}{further arguments (currently unused).}

\item{order}{integer: the order of the serial correlation,}

\item{vcov}{a matrix of covariance for the coefficients or a function to
compute it,}
}
\value{
An object of class \code{"htest"}.
}
\description{
Test of serial correlation for models estimated by GMM
}
\details{
The Arellano--Bond test is a test of correlation based on the residuals of
the estimation. By default, the computation is done with the standard
covariance matrix of the coefficients. A robust estimator of a
covariance matrix can be supplied with the \code{vcov} argument.

Note that \code{mtest} computes like DPD for Ox and xtabond do, i.e., uses for two-steps
models the one-step model's residuals which were used to construct the efficient
two-steps estimator, see \insertCite{DOOR:AREL:BOND:12}{plm}, p. 32, footnote 7;
As noted by \insertCite{AREL:BOND:91}{plm} (p. 282), the m statistic is rather
flexible and can be defined with any consistent GMM estimator which gives leeway
for implementation, but the test's asymptotic  power depends on the estimator's efficiency.
\insertCite{AREL:BOND:91}{plm} (see their footnote 9) used
DPD98 for Gauss (\insertCite{AREL:BOND:98}{plm}) as did
\insertCite{WIND:05}{plm} (see footnote 10) for the basis of his
covariance correction, both with a slightly different implementation.
Hence some results for \code{mtest} with two-step models diverge from original papers,
see examples below.
}
\examples{
data("EmplUK", package = "plm")
# Arellano/Bond 1991, Table 4, column (a1)
ab.a1 <- pgmm(log(emp) ~ lag(log(emp), 1:2) + lag(log(wage), 0:1)
              + lag(log(capital), 0:2) + lag(log(output), 0:2) | lag(log(emp), 2:99),
              data = EmplUK, effect = "twoways", model = "onestep")
mtest(ab.a1, 1L)
mtest(ab.a1, 2L, vcov = vcovHC)

# Windmeijer (2005), table 2, onestep with corrected std. err
ab.b.onestep <- pgmm(log(emp) ~ lag(log(emp), 1:2) + lag(log(wage), 0:1)
                     + log(capital) + lag(log(output), 0:1) | lag(log(emp), 2:99),
                     data = EmplUK, effect = "twoways", model = "onestep")
mtest(ab.b.onestep, 1L, vcov = vcovHC)
mtest(ab.b.onestep, 2L, vcov = vcovHC)

# Arellano/Bond 1991, Table 4, column (a2)
ab.a2 <- pgmm(log(emp) ~ lag(log(emp), 1:2) + lag(log(wage), 0:1)
             + lag(log(capital), 0:2) + lag(log(output), 0:2) | lag(log(emp), 2:99),
             data = EmplUK, effect = "twoways", model = "twosteps")
mtest(ab.a2, 1L)
mtest(ab.a2, 2L) # while a la Arellano/Bond (1991) -0.434
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=pgmm]{pgmm()}}, \code{\link[=vcovHC.pgmm]{vcovHC.pgmm()}}
}
\author{
Yves Croissant
}
\keyword{htest}
