% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ooxml_block_objects.R
\name{unordered_list}
\alias{unordered_list}
\title{Unordered list}
\usage{
unordered_list(str_list = character(0), level_list = integer(0), style = NULL)
}
\arguments{
\item{str_list}{list of strings to be included in the object}

\item{level_list}{list of levels for hierarchy structure. Use
0 for 'no bullet', 1 for level 1, 2 for level 2 and so on.}

\item{style}{text style, a \code{fp_text} object list or a
single \code{fp_text} objects. Use \code{fp_text(font.size = 0, ...)} to
inherit from default sizes of the presentation.}
}
\description{
unordered list of text for PowerPoint
presentations. Each text is associated with
a hierarchy level.
}
\examples{
unordered_list(
level_list = c(1, 2, 2, 3, 3, 1),
str_list = c("Level1", "Level2", "Level2", "Level3", "Level3", "Level1"),
style = fp_text(color = "red", font.size = 0) )
unordered_list(
level_list = c(1, 2, 1),
str_list = c("Level1", "Level2", "Level1"),
style = list(
  fp_text(color = "red", font.size = 0),
  fp_text(color = "pink", font.size = 0),
  fp_text(color = "orange", font.size = 0)
  ))
}
\seealso{
\code{\link{ph_with}}

Other block functions for reporting: 
\code{\link{block_caption}()},
\code{\link{block_list}()},
\code{\link{block_pour_docx}()},
\code{\link{block_section}()},
\code{\link{block_table}()},
\code{\link{block_toc}()},
\code{\link{fpar}()},
\code{\link{plot_instr}()}
}
\concept{block functions for reporting}
