% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thetaHill.R
\name{thetaHill}
\alias{thetaHill}
\title{Hill estimator}
\usage{
thetaHill(x, k = NULL, x0 = NULL, w = NULL)
}
\arguments{
\item{x}{a numeric vector.}

\item{k}{the number of observations in the upper tail to which the Pareto
distribution is fitted.}

\item{x0}{the threshold (scale parameter) above which the Pareto distribution
is fitted.}

\item{w}{an optional numeric vector giving sample weights.}
}
\value{
The estimated shape parameter.
}
\description{
The Hill estimator uses the maximum likelihood principle to estimate the
shape parameter of a Pareto distribution.
}
\details{
The arguments \code{k} and \code{x0} of course correspond with each other.
If \code{k} is supplied, the threshold \code{x0} is estimated with the \eqn{n
- k} largest value in \code{x}, where \eqn{n} is the number of observations.
On the other hand, if the threshold \code{x0} is supplied, \code{k} is given
by the number of observations in \code{x} larger than \code{x0}.  Therefore,
either \code{k} or \code{x0} needs to be supplied.  If both are supplied,
only \code{k} is used (mainly for back compatibility).
}
\note{
The arguments \code{x0} for the threshold (scale parameter) of the
Pareto distribution and \code{w} for sample weights were introduced in
version 0.2.
}
\examples{
data(eusilc)
# equivalized disposable income is equal for each household
# member, therefore only one household member is taken
eusilc <- eusilc[!duplicated(eusilc$db030),]

# estimate threshold
ts <- paretoScale(eusilc$eqIncome, w = eusilc$db090)

# using number of observations in tail
thetaHill(eusilc$eqIncome, k = ts$k, w = eusilc$db090)

# using threshold
thetaHill(eusilc$eqIncome, x0 = ts$x0, w = eusilc$db090)

}
\references{
Hill, B.M. (1975) A simple general approach to inference about
the tail of a distribution. \emph{The Annals of Statistics}, \bold{3}(5),
1163--1174.
}
\seealso{
\code{\link{paretoTail}}, \code{\link{fitPareto}},
\code{\link{thetaPDC}}, \code{\link{thetaWML}}, \code{\link{thetaISE}},
\code{\link{minAMSE}}
}
\author{
Andreas Alfons and Josef Holzer
}
\keyword{manip}
