% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jrc.R
\name{getMessageIds}
\alias{getMessageIds}
\title{Get IDs of all stored messages}
\usage{
getMessageIds(sessionId = NULL, simplify = TRUE)
}
\arguments{
\item{sessionId}{ID of the session for which to return message IDs. Can also be a vector of multiple session IDs.
If \code{NULL}, returns message IDs for all currently active sessions.}

\item{simplify}{If \code{TRUE} and only one session ID is provided (or there is only one active session), returns
a vector of message IDs. Otherwise returns a named list with one vector for each requested session.}
}
\value{
Either a named list or a vector with message IDs.
}
\description{
Returns IDs of all currently stored messages.
}
\details{
For security reasons, most of the messages that are received
from web pages require manual authorization in the R session with \code{\link{authorize}} function. Until that happens,
messages are given randomly generated IDs and are stored in memory. 

This function is a wrapper around method \code{getMessageIds} of class \code{\link{Session}}.
}
\seealso{
\code{\link{authorize}}, \code{\link{getSessionIds}}.
}
