% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jrc.R
\name{closeSession}
\alias{closeSession}
\title{Close one or several client sessions}
\usage{
closeSession(sessionId = NULL, inactive = NULL, old = NULL)
}
\arguments{
\item{sessionId}{IDs of the sessions to close. Can be a vector of multiple IDs.}

\item{inactive}{All sessions that were inactive (didn't receive any messages) for the
specified amount of time (in seconds) will be closed.}

\item{old}{All sessions that were opened for at least specified amount of time (in seconds)
will be closed.}
}
\description{
Closes WebSocket connections for the selected client sessions and removes all the related
information from memory. If no arguments are provided and there is only one active session,
closes it. This function is a wrapper around method \code{closeSession} of 
class \code{\link{App}}.
}
\examples{
\dontrun{
# to run this example an installed web browser is required
start <- Sys.time()
openPage()

app <- getPage()
time <- Sys.time()

app$openPage(FALSE)
app$openPage(FALSE)

print(getSessionIds())

# No sessions will be closed
closeSession(old = Sys.time() - start)
print(getSessionIds())

# One session (the one that has been opened first) will be closed
closeSession(old = Sys.time() - time)
print(getSessionIds())

time <- Sys.time()
sendCommand("jrc.sendCommand('print(\"Hi!\")')", sessionId = getSessionIds()[1],  wait = 3)

# this will close all sessions except for the one, that has just send a command to R session
closeSession(inactive = Sys.time() - time)

# if there is only one active session, sessionId becomes an optional argument
closeSession()

closePage()}

}
