% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ablation.R
\name{ablation_cmdline}
\alias{ablation_cmdline}
\title{Launch ablation with command-line options.}
\usage{
ablation_cmdline(argv = commandArgs(trailingOnly = TRUE))
}
\arguments{
\item{argv}{(\code{character()}) \cr The arguments
provided on the R command line as a character vector, e.g.,
\code{c("-i", "irace.Rdata", "--src", 1)}.}
}
\value{
A list containing the following elements:
\describe{
\item{configurations}{Configurations tested in the ablation.}
\item{instances}{A matrix with the instances used in the experiments. First column has the
instances IDs from \code{iraceResults$scenario$instances}, second column the seed assigned to the instance.}
\item{experiments}{A matrix with the results of the experiments (columns are configurations, rows are instances).}
\item{scenario}{Scenario object with the settings used for the experiments.}
\item{trajectory}{IDs of the best configurations at each step of the ablation.}
\item{best}{Best configuration found in the experiments.}
}
}
\description{
Launch \code{\link[=ablation]{ablation()}} with the same command-line options as the command-line
executable (\code{ablation.exe} in Windows).
}
\details{
The function reads the parameters given on the command line
used to invoke R, launches \code{\link[=ablation]{ablation()}} and possibly \code{\link[=plotAblation]{plotAblation()}}.

List of command-line options:\preformatted{-l,--log-file            Path to the (.Rdata) file created by irace from which
                         the "iraceResults" object will be loaded.
-S,--src                 Source configuration ID. Default: 1.
-T,--target              Target configuration ID. By default the best
                         configuration found by irace.
-P,--params              Specific parameter names to be used for the ablation
                         (separated with commas). By default use all
-t,--type                Type of ablation to perform: "full" will execute each
                         configuration on all "--n-instances" to determine the
                         best-performing one; "racing" will apply racing to
                         find the best configurations. Default: full.
-n,--n-instances         Number of instances used in "full" ablation will be
                         n_instances * scenario$firstTest. Default: 1.
   --seed                Integer value to use as seed for the random number
                         generation. Default: 1234567.
-o,--output-file         Log file to save the ablation log. If "", the results
                         are not saved to a file. Default: log-ablation.Rdata.
-p,--plot                Output filename (.pdf) for the plot. If not given, no
                         plot is created.
-O,--plot-type           Type of plot. Supported values are "mean" and
                         "boxplot". Default: mean.
   --old-path            Old path found in the log-file (.Rdata) given as input
                         to be replaced by --new-path.
   --new-path            New path to replace the path found in the log-file
                         (.Rdata) given as input.
-e,--exec-dir            Directory where the target runner will be run.
-s,--scenario            Scenario file to override the scenario given in the
                         log-file (.Rdata)
   --parallel            Number of calls to targetRunner to execute in
                         parallel. Values 0 or 1 mean no parallelization.
}
}
\examples{
# ablation_cmdline("--help")

}
\author{
Manuel López-Ibáñez
}
\concept{running}
