% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/designMD.R
\name{designMD}
\alias{designMD}
\alias{designMD.default}
\title{Design Matrix Mahalanobis Distance}
\usage{
designMD(object, ...)
}
\arguments{
\item{object}{a fitted model object with a \code{\link{model.matrix}} method.}

\item{\dots}{additional arguments are ignored.}
}
\value{
a numeric vector containing the squared Mahalanobis distances.
}
\description{
Returns the squared Mahalanobis distance of all rows in the design (model)
matrix \eqn{X} and the sample mean vector \eqn{\mu} of the columns
of \eqn{X} with respect to the sample covariance matrix \eqn{\Sigma}.
This is (for vector \eqn{x'} a row of \eqn{X}) defined as
\deqn{d^{2} = (x - \mu)' \Sigma^{-1} (x - \mu)}
where
\deqn{\mu = colMeans(X)}
and
\deqn{\Sigma = cov(X).}
}
\examples{
stack.lm <- lm(stack.loss ~ ., data = stackloss)

# Mahalanobis distance (not squared)
sqrt(designMD(stack.lm))
}
\keyword{methods}
\keyword{regression}
