% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step-call.R
\name{drop_na.dtplyr_step}
\alias{drop_na.dtplyr_step}
\title{Drop rows containing missing values}
\usage{
\method{drop_na}{dtplyr_step}(data, ...)
}
\arguments{
\item{data}{A \code{\link[=lazy_dt]{lazy_dt()}}.}

\item{...}{<\code{\link[tidyr:tidyr_tidy_select]{tidy-select}}> Columns to inspect for
missing values.}
}
\description{
This is a method for the tidyr \code{drop_na()} generic. It is translated to
\code{data.table::na.omit()}
}
\examples{
library(dplyr)
library(tidyr)

dt <- lazy_dt(tibble(x = c(1, 2, NA), y = c("a", NA, "b")))
dt \%>\% drop_na()
dt \%>\% drop_na(x)

vars <- "y"
dt \%>\% drop_na(x, any_of(vars))
}
