#' @title The dimRed package
#'
#' @description This package simplifies dimensionality reduction in R by
#'   providing a framework of S4 classes and methods. dimRed collects
#'   dimensionality reduction methods that are implemented in R and implements
#'   others. It gives them a common interface and provides plotting
#'   functions for visualization and functions for quality assessment.
#'
#' Funding provided by the Department for Biogeochemical Integration,
#' Empirical Inference of the Earth System Group, at the Max Plack
#' Institute for Biogeochemistry, Jena.
#'
#' @references
#'
#' Lee, J.A., Renard, E., Bernard, G., Dupont, P., Verleysen, M.,
#' 2013. Type 1 and 2 mixtures of Kullback-Leibler divergences as cost
#' functions in dimensionality reduction based on similarity
#' preservation. Neurocomputing. 112,
#' 92-107. doi:10.1016/j.neucom.2012.12.036
#'
#' Lee, J.A., Lee, J.A., Verleysen, M., 2008. Rank-based quality
#' assessment of nonlinear dimensionality reduction. Proceedings of
#' ESANN 2008 49-54.
#'
#' Chen, L., Buja, A., 2006. Local Multidimensional Scaling for
#' Nonlinear Dimension Reduction, Graph Layout and Proximity Analysis.
#'
#'
#' @import methods
#' @importFrom magrittr %>%
#'
"_PACKAGE"
