% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_R_NX}
\alias{plot_R_NX}
\title{plot_R_NX}
\usage{
plot_R_NX(x)
}
\arguments{
\item{x}{a list of \code{\link{dimRedResult}} objects. The names of
the list will appear in the legend with the AUC_lnK value.}
}
\value{
A ggplot object, the design can be changed by appending
    \code{theme(...)}
}
\description{
Plot the R_NX curve for different embeddings. Takes a list of
\code{\link{dimRedResult}} objects as input.
Also the Area under the curve values are computed for logarithmic K
(AUC_lnK) and appear in the legend.
}
\examples{

## define which methods to apply
embed_methods <- c("Isomap", "PCA")
## load test data set
data_set <- loadDataSet("3D S Curve", n = 1000)
## apply dimensionality reduction
data_emb <- lapply(embed_methods, function(x) embed(data_set, x))
names(data_emb) <- embed_methods
## plot the R_NX curves:
plot_R_NX(data_emb) +
    ggplot2::theme(legend.title = ggplot2::element_blank(),
                   legend.position = c(0.5, 0.1),
                   legend.justification = c(0.5, 0.1))

}
